<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
require_once PJ_CONTROLLERS_PATH . 'pjAdmin.controller.php';
class pjAdminFiles extends pjAdmin
{
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			$post_max_size = pjUtil::getPostMaxSize();
			if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_SERVER['CONTENT_LENGTH']) && (int) $_SERVER['CONTENT_LENGTH'] > $post_max_size)
			{
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminFiles&action=pjActionIndex&err=AF05");
			}
			
			if (isset($_POST['file_create']))
			{
				$err = 'AF03';
				$file_id_arr = array();
				$client_id_arr = array();
				$files = array();
				foreach ($_FILES['files'] as $k => $l) {
					foreach ($l as $i => $v) {
						if (!array_key_exists($i, $files))
						{
							$files[$i] = array();
						}
						$files[$i][$k] = $v;
					}
				}
				$has_error = false;
				foreach ($files as $file)
				{
					if($file['error'] != 4 && $file['error'] != 0)
					{
						$has_error = true;
						$err = 'AF09';
					}
					$path = $file['name'];
					$extension = pathinfo($path, PATHINFO_EXTENSION);
					$allowed_arr = explode("|", $this->option_arr['o_file_allowed']);
					if(!in_array($extension, $allowed_arr))
					{
						$has_error = true;
						$err = 'AF10';
					}
				}
				if($has_error == false)
				{
					$pjFileModel = pjFileModel::factory();
					foreach ($files as $file)
					{
						$hash = md5(uniqid(rand(), true));
						$cnt = $pjFileModel->reset()->where('hash', $hash)->findCount()->getData();
						while($cnt > 0)
						{
							$hash = md5(uniqid(rand(), true));
							$cnt = $pjFileModel->reset()->where('hash', $hash)->findCount()->getData();
						}
						if(getimagesize($file["tmp_name"]) != false)
						{
							$Image = new pjImage();
							if ($Image->getErrorCode() !== 200)
							{
								if ($Image->load($file))
								{
									$resp = $Image->isConvertPossible();
									if ($resp['status'] === true)
									{
										$file_path = PJ_UPLOAD_PATH . 'files/' . $hash . '.' . $Image->getExtension();
										$thumb_path = PJ_UPLOAD_PATH . 'thumbs/' . $hash . '.' . $Image->getExtension();
										if ($Image->save($file_path))
										{
											$Image->loadImage($file_path);
											$Image->resizeSmart(180, 150);
											$Image->saveImage($thumb_path);
										}
										
										$data = array();
										$data['mime_type'] = $file['type'];
										$data['file_path'] = $file_path;
										$data['thumb_path'] = $thumb_path;
										$data['file_name'] = $file['name'];
										$data['file_size'] = $file['size'];
										$data['hash'] = $hash;
										$data['user_id'] = $this->getUserId();
										$data['client_id'] = ':NULL';
											
										$id = $pjFileModel->reset()->setAttributes($data)->insert()->getInsertId();
										if ($id !== false && (int) $id > 0)
										{
											$pjClientFileModel = pjClientFileModel::factory();
											if(isset($_POST['client_id'])  && count($_POST['client_id']) > 0)
											{
												$pjClientFileModel->begin();
												foreach ($_POST['client_id'] as $client_id)
												{
													$cdata = array();
													$cdata['client_id'] = $client_id;
													$cdata['file_id'] = $id;
													$pjClientFileModel->reset()->setAttributes($cdata)->insert();
													
													$file_id_arr[] = $id;
													$client_id_arr[] = $client_id;
												}
												$pjClientFileModel->commit();
											}
										}
									}
								}
							}
						}else{
							$handle = new pjUpload();
							if ($handle->load($file))
							{
								$data = array();
								$file_ext = $handle->getExtension();
								$file_path = PJ_UPLOAD_PATH . 'files/' . $hash . '.' . $file_ext;
								if($handle->save($file_path))
								{
									$data['mime_type'] = $file['type'];
									$data['file_path'] = $file_path;
									$data['file_name'] = $file['name'];
									$data['file_size'] = $file['size'];
									$data['hash'] = $hash;
									$data['user_id'] = $this->getUserId();
									$data['client_id'] = ':NULL';
								}
									
								$id = $pjFileModel->reset()->setAttributes($data)->insert()->getInsertId();
								if ($id !== false && (int) $id > 0)
								{
									$pjClientFileModel = pjClientFileModel::factory();
									if(isset($_POST['client_id'])  && count($_POST['client_id']) > 0)
									{
										$pjClientFileModel->begin();
										foreach ($_POST['client_id'] as $client_id)
										{
											$cdata = array();
											$cdata['client_id'] = $client_id;
											$cdata['file_id'] = $id;
											$pjClientFileModel->reset()->setAttributes($cdata)->insert();
											
											$file_id_arr[] = $id;
											$client_id_arr[] = $client_id;
										}
										$pjClientFileModel->commit();
									}
								}
							}
						}
					}
					
					$client_id_arr = array_unique($client_id_arr);
					if(!empty($client_id_arr))
					{
						$client_arr = pjClientModel::factory()
							->whereIn('id', $client_id_arr)
							->findAll()
							->getData();
						foreach($client_arr as $client)
						{
							$this->newFileEmail($client, $file_id_arr, $this->option_arr, 'client');
							$this->sendSMS($client, $this->option_arr, 'file', 'client');
						}
					}
				}
				
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminFiles&action=pjActionIndex&err=$err");
			} else {
				$client_arr = pjClientModel::factory()
					->where('status', 'T')
					->orderBy('name ASC')
					->findAll()
					->getData();
				
				$this->set('client_arr', $client_arr);
				
				$this->appendJs('jquery.multiselect.min.js', PJ_THIRD_PARTY_PATH . 'multiselect/');
				$this->appendCss('jquery.multiselect.css', PJ_THIRD_PARTY_PATH . 'multiselect/');
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('additional-methods.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminFiles.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionDeleteFile()
	{
		$this->setAjax(true);
		
		if ($this->isXHR())
		{
			$response = array();
			if ($this->isAdmin() || $this->isEditor())
			{
				$pjFileModel = pjFileModel::factory();
				$arr = $pjFileModel->find($_GET['id'])->getData();
				if ($pjFileModel->reset()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
				{
					pjClientFileModel::factory()->where('file_id', $_GET['id'])->eraseAll();
					
					$file_path = $arr['file_path'];
					$thumb_path = $arr['thumb_path'];
					if (file_exists(PJ_INSTALL_PATH . $file_path)) {
						@unlink(PJ_INSTALL_PATH . $file_path);
					}
					if (file_exists(PJ_INSTALL_PATH . $thumb_path)) {
						@unlink(PJ_INSTALL_PATH . $thumb_path);
					}
					$response['code'] = 200;
				} else {
					$response['code'] = 100;
				}
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteFileBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if ($this->isAdmin() || $this->isEditor())
			{
				if (isset($_POST['record']) && count($_POST['record']) > 0)
				{
					$pjFileModel = pjFileModel::factory();
					$file_arr = $pjFileModel->whereIn('id', $_POST['record'])->findAll()->getData();
					foreach($file_arr as $f)
					{
						$file_path = $f['file_path'];
						$thumb_path = $f['thumb_path'];
						if (file_exists(PJ_INSTALL_PATH . $file_path)) {
							@unlink(PJ_INSTALL_PATH . $file_path);
						}
						if (file_exists(PJ_INSTALL_PATH . $thumb_path)) {
							@unlink(PJ_INSTALL_PATH . $thumb_path);
						}
					}
					$pjFileModel->reset()->whereIn('id', $_POST['record'])->eraseAll();
					pjClientFileModel::factory()->whereIn('file_id', $_POST['record'])->eraseAll();
				}
			}
		}
		exit;
	}
	
	public function pjActionDownloadFileBulk()
	{
		$this->setAjax(true);
	
		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				$pjFileModel = pjFileModel::factory();
				$file_arr = $pjFileModel->whereIn('id', $_POST['record'])->findAll()->getData();
				
				$zip = new pjZipStream();
				foreach($file_arr as $file)
				{
					if (empty($file['file_path']) || !is_file($file['file_path']))
					{
						continue;
					}
					$handle = @fopen($file['file_path'], "rb");
					if ($handle)
					{
						$zip->addLargeFile($file['file_path'], $file['file_name']);
						fclose($handle);
					}
				}
				$zip->finalize();
				$zip->sendZip(sprintf("%s.zip", 'files-'.time()));
			}
		}
		exit;
	}
	
	public function pjActionExportFile()
	{
		$this->checkLogin();
		
		if (isset($_POST['record']) && is_array($_POST['record']))
		{
			$arr = pjFileModel::factory()->whereIn('id', $_POST['record'])->findAll()->getData();
			$csv = new pjCSV();
			$csv
				->setHeader(true)
				->setName("Files-".time().".csv")
				->process($arr)
				->download();
		}
		exit;
	}
	
	public function pjActionGetFile()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjFileModel = pjFileModel::factory();
			
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = $pjFileModel->escapeStr($_GET['q']);
				$q = str_replace(array('%', '_'), array('\%', '\_'), trim($q));
				$pjFileModel->where("(t1.file_name LIKE '%$q%')");
			}
			if(isset($_GET['client_id']) && (int) $_GET['client_id'] > 0)
			{
				$pjFileModel->where('t1.id IN (SELECT TCF.file_id FROM `'.pjClientFileModel::factory()->getTable().'` TCF WHERE TCF.client_id = '.$_GET['client_id'].')');
			}
			$column = 'created';
			$direction = 'DESC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjFileModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}
			
			$tbl_comment = pjCommentModel::factory()->getTable();
			$data = $pjFileModel
				->select("t1.*, t2.name AS client, t3.name AS user,
								(SELECT COUNT(TC.id) FROM `".$tbl_comment."` AS TC WHERE TC.file_id=t1.id) AS cnt_comments,
								(SELECT t4.name FROM `".$tbl_comment."` AS TC LEFT OUTER JOIN `".pjClientModel::factory()->getTable()."` AS t4 ON t4.id=TC.client_id WHERE TC.file_id=t1.id ORDER BY TC.created DESC LIMIT 1) AS by_client,
								(SELECT t5.name FROM `".$tbl_comment."` AS TC LEFT OUTER JOIN `".pjUserModel::factory()->getTable()."` AS t5 ON t5.id=TC.user_id WHERE TC.file_id=t1.id ORDER BY TC.created DESC LIMIT 1) AS by_user,
								(SELECT TC.created FROM `".$tbl_comment."` AS TC WHERE TC.file_id=t1.id ORDER BY TC.created DESC LIMIT 1) AS last_comment,
								(SELECT TC.id FROM `".$tbl_comment."` AS TC WHERE TC.file_id=t1.id ORDER BY TC.created DESC LIMIT 1) AS last_id")
				->join('pjClient', 't1.client_id=t2.id', 'left')
				->join('pjUser', 't1.user_id=t3.id', 'left')
				->orderBy("$column $direction")
				->limit($rowCount, $offset)
				->findAll()
				->getData();
			foreach($data as $k => $v)
			{
				$v['created'] = date($this->option_arr['o_date_format'], strtotime($v['created'])) . ', ' . date($this->option_arr['o_time_format'], strtotime($v['created']));
				$v['file_size'] = pjUtil::formatSizeUnits($v['file_size']);
				if(!empty($v['last_comment']))
				{
					$v['last_comment'] = date($this->option_arr['o_date_format'], strtotime($v['last_comment'])) . ', ' . date($this->option_arr['o_time_format'], strtotime($v['last_comment']));
				}
				$data[$k] = $v;
			}
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
	
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_GET['client_id']) && (int) $_GET['client_id'] > 0)
			{
				$this->set('client', pjClientModel::factory()->find($_GET['client_id'])->getData());
			}
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminFiles.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			$post_max_size = pjUtil::getPostMaxSize();
			if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_SERVER['CONTENT_LENGTH']) && (int) $_SERVER['CONTENT_LENGTH'] > $post_max_size)
			{
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminFiles&action=pjActionIndex&err=AF05");
			}
			
			if (isset($_POST['file_update']))
			{
				$pjFileModel = pjFileModel::factory();
				$arr = $pjFileModel->find($_POST['id'])->getData();
				
				$err = 'AF01';
				$valid = true;
				$data = array();
				$file_id_arr = array();
				$client_id_arr = array();
				if (isset($_FILES['file']) && $_FILES['file']['error'] == 0)
				{
					$path = $_FILES['file']['name'];
					$extension = pathinfo($path, PATHINFO_EXTENSION);
					$allowed_arr = explode("|", $this->option_arr['o_file_allowed']);
					if(in_array($extension, $allowed_arr))
					{
						if(getimagesize($_FILES['file']["tmp_name"]) != false)
						{
							$Image = new pjImage();
							if ($Image->getErrorCode() !== 200)
							{
								$Image->setAllowedTypes(array('image/png', 'image/gif', 'image/jpg', 'image/jpeg', 'image/pjpeg'));
								if ($Image->load($_FILES['file']))
								{
									$resp = $Image->isConvertPossible();
									if ($resp['status'] === true)
									{
										$hash = md5(uniqid(rand(), true));
										$cnt = $pjFileModel->reset()->where('hash', $hash)->findCount()->getData();
										while($cnt > 0)
										{
											$hash = md5(uniqid(rand(), true));
											$cnt = $pjFileModel->reset()->where('hash', $hash)->findCount()->getData();
										}
										$file_path = PJ_UPLOAD_PATH . 'files/' . $hash . '.' . $Image->getExtension();
										$thumb_path = PJ_UPLOAD_PATH . 'thumbs/' . $hash . '.' . $Image->getExtension();
										if ($Image->save($file_path))
										{
											$Image->loadImage($file_path);
											$Image->resizeSmart(180, 150);
											$Image->saveImage($thumb_path);
							
											$data['file_path'] = $file_path;
											$data['thumb_path'] = $thumb_path;
											$data['file_name'] = $_FILES['file']['name'];
											$data['mime_type'] = $_FILES['file']['type'];
											$data['hash'] = $hash;
											$data['file_size'] = $_FILES['file']['size'];
											$data['user_id'] = $this->getUserId();
											$data['client_id'] = ':NULL';
											$pjFileModel->reset()->set('id', $_POST['id'])->modify($data);
											
											$file_id_arr[] = $_POST['id'];
										}
									}
								}
							}
						}else{
							$handle = new pjUpload();
							if ($handle->load($_FILES['file'])) 
							{
								$hash = md5(uniqid(rand(), true));
								$file_path = PJ_UPLOAD_PATH . 'files/' . $hash . '.' . $handle->getExtension();
								if($handle->save($file_path))
								{
									$data['file_path'] = $file_path;
									$data['thumb_path'] = ':NULL';
									$data['file_name'] = $_FILES['file']['name'];
									$data['mime_type'] = $_FILES['file']['type'];
									$data['hash'] = $hash;
									$data['file_size'] = $_FILES['file']['size'];
									$data['user_id'] = $this->getUserId();
									$data['client_id'] = ':NULL';
									$pjFileModel->reset()->set('id', $_POST['id'])->modify($data);
									$file_id_arr[] = $_POST['id'];
								}
							}
						}
						$file_path = $arr['file_path'];
						$thumb_path = $arr['thumb_path'];
						if (file_exists(PJ_INSTALL_PATH . $file_path)) {
							@unlink(PJ_INSTALL_PATH . $file_path);
						}
						if (file_exists(PJ_INSTALL_PATH . $thumb_path)) {
							@unlink(PJ_INSTALL_PATH . $thumb_path);
						}
					}else{
						$err = 'AF12';
						$valid = false;
					}
					
				}else if($_FILES['file']['error'] != 4){
					$err = 'AF11';
					$valid = false;
				}
				
				if($valid == true)
				{
					$pjClientFileModel = pjClientFileModel::factory();
					$pjClientFileModel->where('file_id', $_POST['id'])->eraseAll();
					if(isset($_POST['client_id']) && count($_POST['client_id']) > 0)
					{
						$pjClientFileModel->reset()->begin();
						foreach ($_POST['client_id'] as $client_id){
							$data = array();
							$data['client_id'] = $client_id;
							$data['file_id'] = $_POST['id'];
							$pjClientFileModel->reset()->setAttributes($data)->insert();
							$client_id_arr[] = $client_id;
						}
						$pjClientFileModel->commit();
					}
				}
				
				$client_id_arr = array_unique($client_id_arr);
				if(!empty($client_id_arr) && !empty($file_id_arr))
				{
					$client_arr = pjClientModel::factory()
						->whereIn('id', $client_id_arr)
						->findAll()
						->getData();
					foreach($client_arr as $client)
					{
						$this->newFileEmail($client, $file_id_arr, $this->option_arr, 'client');
						$this->sendSMS($client, $this->option_arr, 'file', 'client');
					}
				}
				if($err == 'AF01')
				{
					pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminFiles&action=pjActionIndex&err=$err");
				}else{
					pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminFiles&action=pjActionUpdate&id=".$_POST['id']."&err=$err");
				}
			} else {
				$tbl_comment = pjCommentModel::factory()->getTable();
				$arr = pjFileModel::factory()					
					->select("t1.*, t2.name AS client, t3.name AS user,
							  (SELECT t4.name FROM `".$tbl_comment."` AS TC LEFT OUTER JOIN `".pjClientModel::factory()->getTable()."` AS t4 ON t4.id=TC.client_id WHERE TC.file_id=t1.id ORDER BY TC.created DESC LIMIT 1) AS by_client,
							  (SELECT t5.name FROM `".$tbl_comment."` AS TC LEFT OUTER JOIN `".pjUserModel::factory()->getTable()."` AS t5 ON t5.id=TC.user_id WHERE TC.file_id=t1.id ORDER BY TC.created DESC LIMIT 1) AS by_user,	
							  (SELECT TC.created FROM `".$tbl_comment."` AS TC WHERE TC.file_id=t1.id ORDER BY created DESC LIMIT 1) AS last_comment,
							  (SELECT TC.id FROM `".$tbl_comment."` AS TC WHERE TC.file_id=t1.id ORDER BY created DESC LIMIT 1) AS last_id,	
							  (SELECT COUNT(TC.id) FROM `".$tbl_comment."` AS TC WHERE TC.file_id=t1.id) AS cnt_comments,	
							  (SELECT GROUP_CONCAT(t2.client_id SEPARATOR '~:~') FROM `".pjClientFileModel::factory()->getTable()."` AS t2 WHERE t2.file_id=t1.id ) AS client_ids")
					->join('pjClient', 't1.client_id=t2.id', 'left')
					->join('pjUser', 't1.user_id=t3.id', 'left')
					->find($_GET['id'])
					->toArray('client_ids', '~:~')
					->getData();
					
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminFiles&action=pjActionIndex&err=AF08");
				}
				$client_arr = pjClientModel::factory()
					->where('status', 'T')
					->orderBy('name ASC')
					->findAll()
					->getData();
				
				$this->set('arr', $arr);
				$this->set('client_arr', $client_arr);
				
				$this->appendJs('jquery.multiselect.min.js', PJ_THIRD_PARTY_PATH . 'multiselect/');
				$this->appendCss('jquery.multiselect.css', PJ_THIRD_PARTY_PATH . 'multiselect/');
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('additional-methods.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminFiles.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionComment()
	{
		$this->checkLogin();
	
		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['comment_create']))
			{
				$data = array();
				$data['ip'] = pjUtil::getClientIp();
				$data['client_id'] = ':NULL';
				$data['user_id'] = $this->getUserId();
				
				$id = pjCommentModel::factory(array_merge($_POST, $data))->insert()->getInsertId();
				
				if ($id !== false && (int) $id > 0)
				{
					$client_id_arr = pjClientFileModel::factory()->where('t1.file_id', $_POST['file_id'])->findAll()->getDataPair(null, 'client_id');
					if(!empty($client_id_arr))
					{
						$arr = pjCommentModel::factory()
							->select('t1.*, t2.file_name')
							->join('pjFile', 't1.file_id=t2.id', 'left')
							->find($id)
							->getData();
						$client_arr = pjClientModel::factory()
							->whereIn('id', $client_id_arr)
							->findAll()
							->getData();
						foreach($client_arr as $client)
						{
							$this->newCommentEmail($client, $arr, $this->option_arr, 'client');
							$this->sendSMS($client, $this->option_arr, 'comment', 'client');
						}
					}
										
					$err = 'AC03';
				} else {
					$err = 'AC04';
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminFiles&action=pjActionComment&id=".$_POST['file_id']."&err=$err");
			} else {
				$tbl_comment = pjCommentModel::factory()->getTable();
				$arr = pjFileModel::factory()
					->select("t1.*, t2.name AS client, t3.name AS user,
							  (SELECT TC.created FROM `".$tbl_comment."` AS TC WHERE TC.file_id=t1.id ORDER BY created DESC LIMIT 1) AS last_comment,
							  (SELECT TC.id FROM `".$tbl_comment."` AS TC WHERE TC.file_id=t1.id ORDER BY created DESC LIMIT 1) AS last_id,
							  (SELECT COUNT(TC.id) FROM `".$tbl_comment."` AS TC WHERE TC.file_id=t1.id) AS cnt_comments,
							  (SELECT GROUP_CONCAT(t2.client_id SEPARATOR '~:~') FROM `".pjClientFileModel::factory()->getTable()."` AS t2 WHERE t2.file_id=t1.id ) AS client_ids")
				  	->join('pjClient', 't1.client_id=t2.id', 'left')
				  	->join('pjUser', 't1.user_id=t3.id', 'left')
				  	->find($_GET['id'])
				  	->toArray('client_ids', '~:~')
				  	->getData();
					
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminFiles&action=pjActionIndex&err=AF08");
				}
				$client_arr = pjClientModel::factory()
					->where('status', 'T')
					->orderBy('name ASC')
					->findAll()
					->getData();
	
				$comment_arr = pjCommentModel::factory()
					->select("t1.*, t2.name AS client, t3.name AS user")
					->join('pjClient', 't2.id=t1.client_id', 'left')
					->join('pjUser', 't3.id=t1.user_id', 'left')
					->where('t1.file_id', $_GET['id'])
					->orderBy("t1.created DESC")
					->findAll()
					->getData();
				
				$this->set('arr', $arr);
				$this->set('client_arr', $client_arr);
				$this->set('comment_arr', $comment_arr);
	
				$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminFiles.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionDeleteComment()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			if (pjCommentModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
}
?>