<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		$bodies_text = str_replace("{SIZE}", ini_get('post_max_size'), @$bodies[$_GET['err']]);
		pjUtil::printNotice(@$titles[$_GET['err']], $bodies_text);
	}
	include_once PJ_VIEWS_PATH . 'pjLayouts/elements/filemenu.php';
	pjUtil::printNotice(__('infoFileCommentsTitle', true), __('infoFileCommentsDesc', true)); 
	?>
	<div class="form pj-form">
		<p>
			<label class="title"><?php __('lblFileName'); ?></label>
			<span class="inline_block">
				<label class="content"><a href="<?php echo PJ_INSTALL_URL . 'file.php?id='.$tpl['arr']['id'].'&amp;hash=' .$tpl['arr']['hash']; ?>" target="_blank"><?php echo $tpl['arr']['file_name'];?></a></label>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblFileSize'); ?></label>
			<span class="inline_block">
				<label class="content"><?php echo pjUtil::formatSizeUnits($tpl['arr']['file_size']);?></label>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblUploadedBy'); ?></label>
			<span class="inline_block">
				<?php
				if(!empty($tpl['arr']['user_id']))
				{ 
					if($controller->isAdmin())
					{
						?>
						<label class="content"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminUsers&amp;action=pjActionUpdate&id=<?php echo $tpl['arr']['user_id'];?>"><?php echo pjSanitize::html($tpl['arr']['user']); ?></a> <?php __('lblOn');?> <?php echo date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['created'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($tpl['arr']['created']));?></label>
						<?php
					}else{
						?>
						<label class="content"><?php echo pjSanitize::html($tpl['arr']['user']); ?> <?php __('lblOn');?> <?php echo date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['created'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($tpl['arr']['created']));?></label>
						<?php
					}
				}else{
					?>
					<label class="content"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminClients&amp;action=pjActionUpdate&id=<?php echo $tpl['arr']['client_id'];?>"><?php echo pjSanitize::html($tpl['arr']['client']); ?></a> <?php __('lblOn');?> <?php echo date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['created'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($tpl['arr']['created']));?></label>
					<?php
				} 
				?>
			</span>
		</p>
	</div>
	
	<div class="pjFsCommentList">
		<div class="heading"><?php __('menuComments');?></div>
		<?php
		if(count($tpl['comment_arr']) > 0)
		{
			foreach($tpl['comment_arr'] as $v)
			{
				?>
				<div class="pjFsCommentBox">
					<div class="b5 overflow">
						<div class="float_left">
							<div class="name"><?php echo !empty($v['client']) ? pjSanitize::html($v['client']) : pjSanitize::html($v['user']);?></div>
							<div class="created"><?php echo date($tpl['option_arr']['o_date_format'], strtotime($v['created'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($v['created']));?></div>
						</div>
						<div class="float_right t3">
							<a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminComments&amp;action=pjActionUpdate&id=<?php echo $v['id'];?>" class="pjPcEdit"></a>
							<a href="#" class="pjPcDelete pjFsDeleteComment" data-id="<?php echo $v['id']?>" data-file_id="<?php echo $tpl['arr']['id'];?>"></a>
						</div>
					</div>
					<div class="comment"><?php echo nl2br(stripcslashes($v['comment']));?></div>
				</div>
				<?php
			}
		} else{
			__('lblNoCommentsFound');
		}
		?>
	</div>
	
	<?php
	pjUtil::printNotice(__('infoAddCommentTitle', true), __('infoAddCommentFileDesc', true));
	?>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminFiles&amp;action=pjActionComment" method="post" id="frmPostComment" class="form pj-form" autocomplete="off" enctype="multipart/form-data">
		<input type="hidden" name="comment_create" value="1" />
		<input type="hidden" name="file_id" value="<?php echo $tpl['arr']['id'];?>" />
		<p>
			<label class="title"><?php __('lblComment'); ?></label>
			<span class="inline_block">
				<textarea name="comment" class="pj-form-field w568 h200 required"></textarea>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblStatus'); ?></label>
			<span class="inline_block">
				<select name="status" id="status" class="pj-form-field required">
					<option value="">-- <?php __('lblChoose'); ?>--</option>
					<?php
					foreach (__('comment_statarr', true) as $k => $v)
					{
						?><option value="<?php echo $k; ?>"<?php echo $k == 'T' ? ' selected="selected"' : null;?>><?php echo $v; ?></option><?php
					}
					?>
				</select>
			</span>
		</p>
		<p>
			<label class="title">&nbsp;</label>
			<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
		</p>
	</form>
	
	<div id="dialogDelete" title="<?php __('lblDeleteComment'); ?>" style="display:none;">
		<div class="t15">
			<?php __('lblDeleteCommentConfirmation'); ?>
		</div>
	</div>
	
	<script type="text/javascript">
		var pjGrid = pjGrid || {};
		pjGrid.queryString = "";
		<?php
		if (isset($_GET['id']) && (int) $_GET['id'] > 0)
		{
			?>pjGrid.queryString += "&file_id=<?php echo (int) $_GET['id']; ?>";<?php
		}
		$statuses = __('comment_statarr', true);
		?>
		var myLabel = myLabel || {};
		myLabel.file_name = "<?php __('lblFileName'); ?>";
		myLabel.posted_by = "<?php __('lblPostedBy'); ?>";
		myLabel.comment = "<?php __('lblComment'); ?>";
		myLabel.approved = "<?php echo $statuses['T']; ?>";
		myLabel.notapproved = "<?php echo $statuses['F']; ?>";
		myLabel.delete_selected = "<?php __('delete_selected'); ?>";
		myLabel.delete_confirmation = "<?php __('delete_confirmation'); ?>";
		myLabel.status = "<?php __('lblStatus'); ?>";
	</script>
	<?php
}
?>