<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		$bodies_text = str_replace("{SIZE}", ini_get('post_max_size'), @$bodies[$_GET['err']]);
		pjUtil::printNotice(@$titles[$_GET['err']], $bodies_text);
	}
	include_once PJ_VIEWS_PATH . 'pjLayouts/elements/filemenu.php';
	pjUtil::printNotice(__('infoUpdateFileTitle', true), __('infoUpdateFileDesc', true)); 
	?>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminFiles&amp;action=pjActionUpdate" method="post" id="frmUpdateFile" class="form pj-form" autocomplete="off" enctype="multipart/form-data">
		<input type="hidden" name="file_update" value="1" />
		<input type="hidden" name="id" value="<?php echo $tpl['arr']['id'];?>" />
		<p>
			<label class="title"><?php __('lblFileName'); ?></label>
			<span class="inline_block">
				<label class="content"><a href="<?php echo PJ_INSTALL_URL . 'file.php?id='.$tpl['arr']['id'].'&amp;hash=' .$tpl['arr']['hash']; ?>" target="_blank"><?php echo $tpl['arr']['file_name'];?></a></label>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblFileSize'); ?></label>
			<span class="inline_block">
				<label class="content"><?php echo pjUtil::formatSizeUnits($tpl['arr']['file_size']);?></label>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblUploadedBy'); ?></label>
			<span class="inline_block">
				<?php
				if(!empty($tpl['arr']['user_id']))
				{ 
					if($controller->isAdmin())
					{
						?>
						<label class="content"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminUsers&amp;action=pjActionUpdate&id=<?php echo $tpl['arr']['user_id'];?>"><?php echo pjSanitize::html($tpl['arr']['user']); ?></a> <?php __('lblOn');?> <?php echo date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['created'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($tpl['arr']['created']));?></label>
						<?php
					}else{
						?>
						<label class="content"><?php echo pjSanitize::html($tpl['arr']['user']); ?> <?php __('lblOn');?> <?php echo date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['created'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($tpl['arr']['created']));?></label>
						<?php
					}
				}else{
					?>
					<label class="content"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminClients&amp;action=pjActionUpdate&id=<?php echo $tpl['arr']['client_id'];?>"><?php echo pjSanitize::html($tpl['arr']['client']); ?></a> <?php __('lblOn');?> <?php echo date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['created'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($tpl['arr']['created']));?></label>
					<?php
				} 
				?>
			</span>
		</p>
		<p>
			<label class="title"><?php __('menuComments'); ?></label>
			<span class="inline_block">
				<?php
				if($tpl['arr']['cnt_comments'] > 0)
				{ 
					?>
					<label class="content"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminFiles&amp;action=pjActionComment&id=<?php echo $tpl['arr']['id'];?>"><?php echo $tpl['arr']['cnt_comments'];?></a></label>
					<?php
				}else{
					?>
					<label class="content"><?php echo $tpl['arr']['cnt_comments'];?></label>
					<?php
				} 
				?>
			</span>
		</p>
		<?php
		if(!empty($tpl['arr']['last_comment']))
		{ 
			?>
			<p>
				<label class="title"><?php __('lblLastComment'); ?></label>
				<span class="inline_block">
					<label class="content">
						<a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminComments&amp;action=pjActionUpdate&id=<?php echo $tpl['arr']['last_id'];?>"><?php echo date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['last_comment'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($tpl['arr']['last_comment']));?></a> <?php __('lblBy')?> <?php echo !empty($tpl['arr']['by_client']) ? $tpl['arr']['by_client'] : $tpl['arr']['by_user'];?> 
					</label>
				</span>
			</p>
			<?php
		} 
		?>
		<p>
			<label class="title"><?php __('lblReplaceFile'); ?></label>
			<span class="inline_block">
				<input name="file" type="file" class="pj-form-field w350" data-msg-extension="<?php __('lblExtensionMessage');?>"/>
			</span>
		</p>
		
		<p>
			<label class="title"><?php __('lblClients'); ?></label>
			<span class="inline_block">
				<select name="client_id[]" id="client_id" class="pj-form-field" multiple="multiple" size="5" data-msg-required="<?php __('lblFieldRequired'); ?>">
					<?php
					foreach ($tpl['client_arr'] as $v)
					{
						?><option value="<?php echo $v['id']; ?>"<?php echo in_array($v['id'], $tpl['arr']['client_ids']) ? ' selected="selected"' : null;?>><?php echo stripslashes($v['name']); ?></option><?php
					}
					?>
				</select>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblStatus'); ?></label>
			<span class="inline_block">
				<select name="status" id="status" class="pj-form-field required" data-msg-required="<?php __('lblFieldRequired');?>">
					<option value="">-- <?php __('lblChoose'); ?>--</option>
					<?php
					foreach (__('u_statarr', true) as $k => $v)
					{
						?><option value="<?php echo $k; ?>"<?php echo $k == $tpl['arr']['status'] ? ' selected="selected"' : NULL;?>><?php echo $v; ?></option><?php
					}
					?>
				</select>
			</span>
		</p>	
		<p>
			<label class="title">&nbsp;</label>
			<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
			<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminFiles&action=pjActionIndex';" />
		</p>
	</form>
	<script type="text/javascript">
		var myLabel = myLabel || {};
		myLabel.select_clients = "<?php __('lblSelectClients');?>";
		myLabel.extension_message = "<?php __('lblExtensionMessage');?>";
		myLabel.allowed_extension = "<?php echo $tpl['option_arr']['o_file_allowed']; ?>";
	</script>
	<?php
}
?>