BEGIN;

DROP TABLE IF EXISTS `filesharing_comments`;
CREATE TABLE IF NOT EXISTS `filesharing_comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `client_id` int(10) unsigned DEFAULT NULL,
  `file_id` int(10) unsigned NOT NULL,
  `comment` text DEFAULT NULL,
  `ip` varchar(50) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `id` (`id`),
  KEY `user_id` (`user_id`),
  KEY `client_id` (`client_id`),
  KEY `file_id` (`file_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `filesharing_clients`;
CREATE TABLE IF NOT EXISTS `filesharing_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `phone` varchar(255) DEFAULT NULL,
  `ip` varchar(15) default NULL,
  `last_login` datetime default NULL,
  `created` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `id` (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `filesharing_clients_files`;
CREATE TABLE IF NOT EXISTS `filesharing_clients_files` (
  `client_id` int(10) unsigned NOT NULL,
  `file_id` int(10) unsigned NOT NULL,
  `is_favorite` enum('T','F') DEFAULT 'F',
  PRIMARY KEY (`client_id`, `file_id`),
  KEY `client_id` (`client_id`),
  KEY `file_id` (`file_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `filesharing_files`;
CREATE TABLE IF NOT EXISTS `filesharing_files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mime_type` varchar(255) DEFAULT NULL,
  `file_path` varchar(255) DEFAULT NULL,
  `thumb_path` varchar(255) DEFAULT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `file_size` int(11) DEFAULT NULL,
  `hash` varchar(255) DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `client_id` int(10) unsigned DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `filesharing_fields`;
CREATE TABLE IF NOT EXISTS `filesharing_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `filesharing_multi_lang`;
CREATE TABLE IF NOT EXISTS `filesharing_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `filesharing_options`;
CREATE TABLE IF NOT EXISTS `filesharing_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `filesharing_roles`;
CREATE TABLE IF NOT EXISTS `filesharing_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `filesharing_users`;
CREATE TABLE IF NOT EXISTS `filesharing_users` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) default NULL,
  `password` blob,
  `name` varchar(255) default NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime default NULL,
  `status` enum('T','F') NOT NULL default 'T',
  `is_active` enum('T','F') NOT NULL default 'F',
  `ip` varchar(15) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `filesharing_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'addLocale', 'backend', 'Add language', 'script', NULL),
(2, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(3, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(4, 'backend', 'backend', 'Backend titles', 'script', NULL),
(5, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(6, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(7, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(8, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(9, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(10, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(11, 'btnLogin', 'backend', 'Login', 'script', NULL),
(12, 'btnReset', 'backend', 'Reset', 'script', NULL),
(13, 'btnSave', 'backend', 'Save', 'script', NULL),
(14, 'btnSearch', 'backend', 'Search', 'script', NULL),
(15, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(16, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(17, 'created', 'backend', 'Created', 'script', NULL),
(18, 'email', 'backend', 'E-Mail', 'script', NULL),
(19, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(20, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(21, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(22, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(23, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(24, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(25, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(26, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(27, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(28, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(29, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(30, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(31, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(32, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(33, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(34, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(35, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(36, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(37, 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
(38, 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
(39, 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
(40, 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
(41, 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
(42, 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
(43, 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
(44, 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
(45, 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
(46, 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
(47, 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
(48, 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
(49, 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
(50, 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
(51, 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
(52, 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
(53, 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
(54, 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
(55, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(56, 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
(57, 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
(58, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(59, 'lblDays', 'backend', 'Days', 'script', NULL),
(60, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(61, 'lblError', 'backend', 'Error', 'script', NULL),
(62, 'lblExport', 'backend', 'Export', 'script', NULL),
(63, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(64, 'lblIp', 'backend', 'IP address', 'script', NULL),
(65, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(66, 'lblName', 'backend', 'Name', 'script', NULL),
(67, 'lblNo', 'backend', 'No', 'script', NULL),
(68, 'lblOption', 'backend', 'Option', 'script', NULL),
(69, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(70, 'lblRole', 'backend', 'Role', 'script', NULL),
(71, 'lblStatus', 'backend', 'Status', 'script', NULL),
(72, 'lblType', 'backend', 'Type', 'script', NULL),
(73, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(74, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(75, 'lblValue', 'backend', 'Value', 'script', NULL),
(76, 'lblYes', 'backend', 'Yes', 'script', NULL),
(77, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(78, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(79, 'locales', 'backend', 'Languages', 'script', NULL),
(80, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(81, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(82, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(83, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(84, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(85, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(86, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(87, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(88, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(89, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(90, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(91, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(92, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(93, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(94, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(95, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(96, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(97, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(98, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(99, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(100, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(101, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(102, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(103, 'pass', 'backend', 'Password', 'script', NULL),
(125, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(126, 'url', 'backend', 'URL', 'script', NULL),
(127, 'user', 'backend', 'Username', 'script', NULL),
(128, 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(129, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(130, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(131, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(132, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(133, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(134, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(135, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(136, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(137, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(138, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(139, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(140, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(141, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(142, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(143, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(144, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(145, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(146, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(147, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(148, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(149, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(150, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(151, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(152, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(153, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(154, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(155, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(156, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(159, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(160, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(161, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(162, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(163, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(164, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(165, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(166, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(167, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(168, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(169, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(170, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(171, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(174, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(175, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(176, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(177, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(178, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(179, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(180, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(181, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(182, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(183, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(184, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(185, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(186, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(187, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(188, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(189, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(190, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(191, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(192, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(193, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(194, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(195, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(196, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(197, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(198, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(199, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(200, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(201, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(202, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(203, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(204, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(205, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(206, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(207, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(208, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(209, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(210, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(211, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(212, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(213, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(214, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(215, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(216, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(217, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(218, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(219, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(220, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(221, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(222, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(223, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(224, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(225, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(226, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(227, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(228, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(229, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(230, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(231, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(232, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(233, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(234, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(235, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(236, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(237, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(238, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(239, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(240, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(241, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(242, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(243, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(244, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(245, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(246, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(247, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(248, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(249, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(250, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(251, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(252, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(253, 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(254, 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL),
(255, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(256, 'email_taken', 'backend', 'Label / email taken', 'script', NULL),
(308, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(360, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(361, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(480, 'infoUsersTitle', 'backend', 'Infobox / List of users', 'script', NULL),
(481, 'infoUsersDesc', 'backend', 'Infobox / List of users', 'script', NULL),
(482, 'btnAddUser', 'backend', 'Button / + Add user', 'script', NULL),
(483, 'gridEmptyTitle', 'backend', 'Grid / No records selected', 'script', NULL),
(484, 'gridEmptyBody', 'backend', 'Grid / You need to select at least a single record.', 'script', NULL),
(485, 'infoAddUserTitle', 'backend', 'Infobox / Add user', 'script', NULL),
(486, 'infoAddUserDesc', 'backend', 'Infobox / Add user', 'script', NULL),
(487, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(488, 'infoUpdateUserTitle', 'backend', 'Infobox / Update user', 'script', NULL),
(489, 'infoUpdateUserDesc', 'backend', 'Infobox / Update user', 'script', NULL),
(490, 'menuGeneral', 'backend', 'Menu / General', 'script', NULL),
(491, 'infoGeneralTitle', 'backend', 'Infobox / General options', 'script', NULL),
(492, 'infoGeneralDesc', 'backend', 'Infobox / General options', 'script', NULL),
(493, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(595, 'menuClients', 'backend', 'Menu / Clients', 'script', NULL),
(596, 'menuFiles', 'backend', 'Menu / Files', 'script', NULL),
(597, 'menuComments', 'backend', 'Menu / Comments', 'script', NULL),
(598, 'tabNotifications', 'backend', 'Tab / Notifications', 'script', NULL),
(599, 'tabToClients', 'backend', 'Tab / To clients', 'script', NULL),
(600, 'tabToAdministrators', 'backend', 'Tab / To administrators', 'script', NULL),
(601, 'opt_o_comments_order', 'backend', 'Options / Comments order', 'script', NULL),
(602, 'opt_o_comments_per_page', 'backend', 'Options / Comments per page', 'script', NULL),
(603, 'opt_o_file_allowed', 'backend', 'Options / File allowed', 'script', NULL),
(604, 'opt_o_banned_words', 'backend', 'Options / Banned words', 'script', NULL),
(605, 'option_tips_ARRAY_o_banned_words', 'arrays', 'option_tips_ARRAY_o_banned_words', 'script', NULL),
(606, 'infoGeneralOptionTitle', 'backend', 'Infobox / General options', 'script', NULL),
(607, 'infoGeneralOptionDesc', 'backend', 'Infobox / General options', 'script', NULL),
(608, 'enum_arr_ARRAY_new_on_top', 'arrays', 'enum_arr_ARRAY_new_on_top', 'script', NULL),
(609, 'enum_arr_ARRAY_new_at_bottom', 'arrays', 'enum_arr_ARRAY_new_at_bottom', 'script', NULL),
(610, 'enum_arr_ARRAY_mail', 'arrays', 'enum_arr_ARRAY_mail', 'script', NULL),
(611, 'enum_arr_ARRAY_smtp', 'arrays', 'enum_arr_ARRAY_smtp', 'script', NULL),
(612, 'infoClientsEmailTitle', 'backend', 'Infobox / Notifications sent to clients', 'script', NULL),
(613, 'infoClientsEmailDesc', 'backend', 'Infobox / Notifications sent to clients', 'script', NULL),
(614, 'lblNewFileNotifiation', 'backend', 'Label / New file notification', 'script', NULL),
(615, 'lblNewCommentNotifiation', 'backend', 'Label / New comment notification', 'script', NULL),
(616, 'lblSubject', 'backend', 'Label / Subject', 'script', NULL),
(617, 'lblMessage', 'backend', 'Label / Message', 'script', NULL),
(618, 'infoClientsSmsTitle', 'backend', 'Infobox / Sms notifications', 'script', NULL),
(619, 'infoClientsSmsDesc', 'backend', 'Infobox / Sms notifications', 'script', NULL),
(620, 'lblNewFilePosted', 'backend', 'Label / New file posted', 'script', NULL),
(621, 'lblNewCommentPosted', 'backend', 'Label / New comment posted', 'script', NULL),
(622, 'infoAdminsEmailTitle', 'backend', 'Infobox / Notifications sent to administrators', 'script', NULL),
(623, 'infoAdminsEmailDesc', 'backend', 'Infobox / Notifications sent to administrators', 'script', NULL),
(624, 'infoAdminsSmsTitle', 'backend', 'Infobox / Sms sent to administrators', 'script', NULL),
(625, 'infoAdminsSmsDesc', 'backend', 'Infobox / Sms sent to administrators', 'script', NULL),
(626, 'lblNewFileTokens', 'backend', 'Label / New file tokens', 'script', NULL),
(627, 'lblNewCommentTokens', 'backend', 'Label / New comment tokens', 'script', NULL),
(628, 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
(629, 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
(630, 'error_titles_ARRAY_ACL01', 'arrays', 'error_titles_ARRAY_ACL01', 'script', NULL),
(631, 'error_bodies_ARRAY_ACL01', 'arrays', 'error_bodies_ARRAY_ACL01', 'script', NULL),
(632, 'error_titles_ARRAY_ACL03', 'arrays', 'error_titles_ARRAY_ACL03', 'script', NULL),
(633, 'error_bodies_ARRAY_ACL03', 'arrays', 'error_bodies_ARRAY_ACL03', 'script', NULL),
(634, 'error_titles_ARRAY_ACL04', 'arrays', 'error_titles_ARRAY_ACL04', 'script', NULL),
(635, 'error_bodies_ARRAY_ACL04', 'arrays', 'error_bodies_ARRAY_ACL04', 'script', NULL),
(636, 'error_titles_ARRAY_ACL08', 'arrays', 'error_titles_ARRAY_ACL08', 'script', NULL),
(637, 'error_bodies_ARRAY_ACL08', 'arrays', 'error_bodies_ARRAY_ACL08', 'script', NULL),
(638, 'infoClientsTitle', 'backend', 'Infobox / List of clients', 'script', NULL),
(639, 'infoClientsDesc', 'backend', 'Infobox / List of clients', 'script', NULL),
(640, 'btnAddClient', 'backend', 'Button / + Add client', 'script', NULL),
(641, 'infoAddClientTitle', 'backend', 'Infobox / Add client', 'script', NULL),
(642, 'infoAddClientDesc', 'backend', 'Infobox / Add client', 'script', NULL),
(643, 'infoUpdateClientTitle', 'backend', 'Infobox / Update client', 'script', NULL),
(644, 'infoUpdateClientDesc', 'backend', 'Infobox / Update client', 'script', NULL),
(645, 'lblFieldRequired', 'backend', 'Label / This field is required.', 'script', NULL),
(646, 'lblEmailInvalid', 'backend', 'Label / Email is invalid.', 'script', NULL),
(647, 'lblEmailUsed', 'backend', 'Label / Email is already used.', 'script', NULL),
(648, 'infoFileListTitle', 'backend', 'Infobox / List of files', 'script', NULL),
(649, 'infoFileListDesc', 'backend', 'Infobox / List of files', 'script', NULL),
(650, 'btnAddFiles', 'backend', 'Button / + Add file(s)', 'script', NULL),
(651, 'lblFileName', 'backend', 'Label / File name', 'script', NULL),
(652, 'lblFileSize', 'backend', 'Label / File size', 'script', NULL),
(653, 'lblUploaded', 'backend', 'Label / Uploaded', 'script', NULL),
(654, 'lblLastComment', 'backend', 'Label / Last comment', 'script', NULL),
(655, 'lblSelectClients', 'backend', 'Label / Select clients', 'script', NULL),
(656, 'lblExtensionMessage', 'backend', 'Label / Extensions allowed message', 'script', NULL),
(657, 'infoAddFilesTitle', 'backend', 'Infobox / Add file(s)', 'script', NULL),
(658, 'infoAddFilesDesc', 'backend', 'Infobox / Add file(s)', 'script', NULL),
(659, 'lblFiles', 'backend', 'Labe / File(s)', 'script', NULL),
(660, 'lblClients', 'backend', 'Labe / Client(s)', 'script', NULL),
(661, 'lblNoClientsAvailable', 'backend', 'Labe / No clients message.', 'script', NULL),
(662, 'error_titles_ARRAY_AF01', 'arrays', 'error_titles_ARRAY_AF01', 'script', NULL),
(663, 'error_bodies_ARRAY_AF01', 'arrays', 'error_bodies_ARRAY_AF01', 'script', NULL),
(664, 'error_titles_ARRAY_AF03', 'arrays', 'error_titles_ARRAY_AF03', 'script', NULL),
(665, 'error_bodies_ARRAY_AF03', 'arrays', 'error_bodies_ARRAY_AF03', 'script', NULL),
(666, 'error_titles_ARRAY_AF05', 'arrays', 'error_titles_ARRAY_AF05', 'script', NULL),
(667, 'error_bodies_ARRAY_AF05', 'arrays', 'error_bodies_ARRAY_AF05', 'script', NULL),
(668, 'error_titles_ARRAY_AF08', 'arrays', 'error_titles_ARRAY_AF08', 'script', NULL),
(669, 'error_bodies_ARRAY_AF08', 'arrays', 'error_bodies_ARRAY_AF08', 'script', NULL),
(670, 'error_titles_ARRAY_AF09', 'arrays', 'error_titles_ARRAY_AF09', 'script', NULL),
(671, 'error_bodies_ARRAY_AF09', 'arrays', 'error_bodies_ARRAY_AF09', 'script', NULL),
(672, 'error_bodies_ARRAY_AF10', 'arrays', 'error_bodies_ARRAY_AF10', 'script', NULL),
(673, 'error_titles_ARRAY_AF10', 'arrays', 'error_titles_ARRAY_AF10', 'script', NULL),
(674, 'error_titles_ARRAY_AF11', 'arrays', 'error_titles_ARRAY_AF11', 'script', NULL),
(675, 'error_bodies_ARRAY_AF11', 'arrays', 'error_bodies_ARRAY_AF11', 'script', NULL),
(676, 'error_bodies_ARRAY_AF12', 'arrays', 'error_bodies_ARRAY_AF12', 'script', NULL),
(677, 'error_titles_ARRAY_AF12', 'arrays', 'error_titles_ARRAY_AF12', 'script', NULL),
(685, 'infoUpdateFileTitle', 'backend', 'Infobox / Update file', 'script', NULL),
(686, 'infoUpdateFileDesc', 'backend', 'Infobox / Update file', 'script', NULL),
(687, 'lblFile', 'backend', 'Label / File', 'script', NULL),
(688, 'lblCurrentFile', 'backend', 'Label / Current file', 'script', NULL),
(689, 'front_file_not_found', 'frontend', 'Label / File not found.', 'script', NULL),
(690, 'front_hash_not_match', 'frontend', 'Label / Hash value does not match.', 'script', NULL),
(691, 'comment_statarr_ARRAY_T', 'arrays', 'comment_statarr_ARRAY_T', 'script', NULL),
(692, 'comment_statarr_ARRAY_F', 'arrays', 'comment_statarr_ARRAY_F', 'script', NULL),
(693, 'infoCommentsTitle', 'backend', 'Infobox / List of comments', 'script', NULL),
(694, 'infoCommentsDesc', 'backend', 'Infobox / List of comments', 'script', NULL),
(695, 'lblPostedBy', 'backend', 'Label / Posted by', 'script', NULL),
(696, 'lblComment', 'backend', 'Label / Comment', 'script', NULL),
(697, 'btnAddComment', 'backend', 'Button / + Add comment', 'script', NULL),
(698, 'infoAddCommentTitle', 'backend', 'Infobox / Add comment', 'script', NULL),
(699, 'infoAddCommentDesc', 'backend', 'Infobox / Add comment', 'script', NULL),
(700, 'error_titles_ARRAY_AC01', 'arrays', 'error_titles_ARRAY_AC01', 'script', NULL),
(701, 'error_bodies_ARRAY_AC01', 'arrays', 'error_bodies_ARRAY_AC01', 'script', NULL),
(702, 'error_titles_ARRAY_AC03', 'arrays', 'error_titles_ARRAY_AC03', 'script', NULL),
(703, 'error_bodies_ARRAY_AC03', 'arrays', 'error_bodies_ARRAY_AC03', 'script', NULL),
(704, 'error_titles_ARRAY_AC04', 'arrays', 'error_titles_ARRAY_AC04', 'script', NULL),
(705, 'error_bodies_ARRAY_AC04', 'arrays', 'error_bodies_ARRAY_AC04', 'script', NULL),
(706, 'error_titles_ARRAY_AC08', 'arrays', 'error_titles_ARRAY_AC08', 'script', NULL),
(707, 'error_bodies_ARRAY_AC08', 'arrays', 'error_bodies_ARRAY_AC08', 'script', NULL),
(708, 'infoUpdateCommentTitle', 'backend', 'Infobox / Update comment', 'script', NULL),
(709, 'infoUpdateCommentDesc', 'backend', 'Infobox / Update comment', 'script', NULL),
(710, 'lblClient', 'backend', 'Label / Client', 'script', NULL),
(711, 'lblUser', 'backend', 'Label / User', 'script', NULL),
(713, 'lblAdministrator', 'backend', 'Label / Administrator', 'script', NULL),
(714, 'lblUploadedBy', 'backend', 'Label / Uploaded by', 'script', NULL),
(715, 'lblOn', 'backend', 'Label / on', 'script', NULL),
(716, 'menuInstallPreview', 'backend', 'Menu / Install & Preview', 'script', NULL),
(717, 'opt_o_theme', 'backend', 'Options / Theme', 'script', NULL),
(718, 'btnPreview', 'backend', 'Button / Preview', 'script', NULL),
(719, 'btnGetInstallCode', 'backend', 'Button / Get Install Code', 'script', NULL),
(720, 'infoInstallTitle', 'backend', 'Infobox / Install code', 'script', NULL),
(721, 'infoInstallDesc', 'backend', 'Infobox / Install code', 'script', NULL),
(722, 'lblSelectTheme', 'backend', 'Label / Select theme', 'script', NULL),
(723, 'lblInstallPhp1_1', 'backend', 'Label / Install step 1', 'script', NULL),
(724, 'lblInstallPhp1_2', 'backend', 'Label / Install step 2', 'script', NULL),
(725, 'lblInstallPhp1_3', 'backend', 'Label / Install step 3', 'script', NULL),
(726, 'front_btn_add_file', 'frontend', 'Button / + Add file', 'script', NULL),
(727, 'front_btn_profile', 'frontend', 'Button / Profile', 'script', NULL),
(728, 'front_btn_logout', 'frontend', 'Button / Logout', 'script', NULL),
(729, 'front_sort_by', 'frontend', 'Label / Sort by', 'script', NULL),
(730, 'front_date', 'frontend', 'Label / date', 'script', NULL),
(731, 'front_file_name', 'frontend', 'Label / file name', 'script', NULL),
(732, 'front_size', 'frontend', 'Label / Size', 'script', NULL),
(733, 'front_date_uploaded', 'frontend', 'Label / Date uploaded', 'script', NULL),
(734, 'front_last_comment', 'frontend', 'Label / Last comment', 'script', NULL),
(735, 'front_view_as', 'frontend', 'Label / View as', 'script', NULL),
(736, 'front_grid', 'frontend', 'Label / Grid', 'script', NULL),
(737, 'front_table', 'frontend', 'Label / Table', 'script', NULL),
(738, 'front_login_title', 'frontend', 'Label / Login to your account', 'script', NULL),
(739, 'front_login_description', 'frontend', 'Label / Login description', 'script', NULL),
(740, 'front_email', 'frontend', 'Label / Email address', 'script', NULL),
(741, 'front_password', 'frontend', 'Label / Password', 'script', NULL),
(742, 'front_validation_ARRAY_required', 'arrays', 'front_validation_ARRAY_required', 'script', NULL),
(743, 'front_validation_ARRAY_email', 'arrays', 'front_validation_ARRAY_email', 'script', NULL),
(744, 'front_login', 'frontend', 'Label / Login', 'script', NULL),
(745, 'front_forgot_password', 'frontend', 'Label / Forgot password', 'script', NULL),
(746, 'front_forgot_title', 'frontend', 'Label / Forgot your password?', 'script', NULL),
(747, 'front_forgot_description', 'frontend', 'Label / Forgot password description', 'script', NULL),
(748, 'front_send_new_password', 'frontend', 'Label / Send new password', 'script', NULL),
(749, 'front_err_ARRAY_LOG01', 'arrays', 'front_err_ARRAY_LOG01', 'script', NULL),
(750, 'front_err_ARRAY_LOG02', 'arrays', 'front_err_ARRAY_LOG02', 'script', NULL),
(751, 'front_err_ARRAY_LOG03', 'arrays', 'front_err_ARRAY_LOG03', 'script', NULL),
(752, 'front_err_ARRAY_LOG04', 'arrays', 'front_err_ARRAY_LOG04', 'script', NULL),
(753, 'front_err_ARRAY_LOG05', 'arrays', 'front_err_ARRAY_LOG05', 'script', NULL),
(754, 'front_err_ARRAY_LOG06', 'arrays', 'front_err_ARRAY_LOG06', 'script', NULL),
(755, 'front_err_ARRAY_LOG07', 'arrays', 'front_err_ARRAY_LOG07', 'script', NULL),
(756, 'lblForgotPasswordNotifiation', 'backend', 'Label / Forgot  password notification', 'script', NULL),
(757, 'lblForgotPasswordTokens', 'backend', 'Label / Forgot password tokens', 'script', NULL),
(758, 'front_err_ARRAY_FOR01', 'arrays', 'front_err_ARRAY_FOR01', 'script', NULL),
(759, 'front_err_ARRAY_FOR02', 'arrays', 'front_err_ARRAY_FOR02', 'script', NULL),
(760, 'front_err_ARRAY_FOR03', 'arrays', 'front_err_ARRAY_FOR03', 'script', NULL),
(761, 'front_err_ARRAY_FOR04', 'arrays', 'front_err_ARRAY_FOR04', 'script', NULL),
(762, 'front_msg_ARRAY_FOR01', 'arrays', 'front_msg_ARRAY_FOR01', 'script', NULL),
(763, 'front_btn_files', 'frontend', 'Button / Files', 'script', NULL),
(764, 'front_my_profile', 'frontend', 'Label / My profile', 'script', NULL),
(765, 'front_name', 'frontend', 'Label / Name', 'script', NULL),
(766, 'front_phone', 'frontend', 'Label / Phone', 'script', NULL),
(767, 'front_btn_save', 'frontend', 'Button / Save', 'script', NULL),
(768, 'front_msg_ARRAY_PRO01', 'arrays', 'front_msg_ARRAY_PRO01', 'script', NULL),
(769, 'front_btn_upload', 'frontend', 'Button / Upload', 'script', NULL),
(770, 'front_btn_remove_files', 'frontend', 'Button / Remove files', 'script', NULL),
(771, 'front_add_file_description', 'frontend', 'Button / Add file description', 'script', NULL),
(772, 'front_validation_ARRAY_extension', 'arrays', 'front_validation_ARRAY_extension', 'script', NULL),
(773, 'front_msg_ARRAY_FF01', 'arrays', 'front_msg_ARRAY_FF01', 'script', NULL),
(774, 'front_err_ARRAY_FF01', 'arrays', 'front_err_msg_ARRAY_FF01', 'script', NULL),
(775, 'front_err_ARRAY_FF02', 'arrays', 'front_err_msg_ARRAY_FF02', 'script', NULL),
(776, 'opt_o_files_per_page', 'backend', 'Options / Files per page', 'script', NULL),
(777, 'front_files_not_found', 'frontend', 'Label / Files not found.', 'script', NULL),
(778, 'front_paging_previous', 'frontend', 'Label / prev', 'script', NULL),
(779, 'front_paging_next', 'frontend', 'Label / next', 'script', NULL),
(780, 'tabDetails', 'backend', 'Tab / Details', 'script', NULL),
(781, 'infoFileCommentsTitle', 'backend', 'Infobox / Comments', 'script', NULL),
(782, 'infoFileCommentsDesc', 'backend', 'Infobox / Comments', 'script', NULL),
(783, 'infoAddCommentFileDesc', 'backend', 'Infobox / Add comment for file', 'script', NULL),
(784, 'lblLastUploaded', 'backend', 'Label / Last uploaded on', 'script', NULL),
(786, 'lblLastCommentOn', 'backend', 'Label / Last comment on', 'script', NULL),
(787, 'lblLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(788, 'lblReplyToComment', 'backend', 'Label / Reply to comment', 'script', NULL),
(789, 'lblBy', 'backend', 'Label / by', 'script', NULL),
(790, 'lblReplaceFile', 'backend', 'Label / Replace file', 'script', NULL),
(791, 'front_favorite_on_top', 'frontend', 'Label / Favorite on top', 'script', NULL),
(792, 'front_back', 'frontend', 'Label / Back', 'script', NULL),
(793, 'front_uploaded_on', 'frontend', 'Label / Uploaded on', 'script', NULL),
(794, 'front_uploaded_by', 'frontend', 'Label / Uploaded by', 'script', NULL),
(795, 'front_file_size', 'frontend', 'Label / File size', 'script', NULL),
(796, 'front_comments', 'frontend', 'Label / Comments', 'script', NULL),
(797, 'front_no_comments_found', 'frontend', 'Label / No comments found.', 'script', NULL),
(798, 'front_leave_a_comment', 'frontend', 'Label / Leave a comment', 'script', NULL),
(799, 'front_your_message', 'frontend', 'Label / Your message', 'script', NULL),
(800, 'front_btn_send', 'frontend', 'Button / Send', 'script', NULL),
(801, 'front_msg_ARRAY_COM01', 'arrays', 'front_msg_ARRAY_COM01', 'script', NULL),
(802, 'front_err_ARRAY_COM01', 'arrays', 'front_err_ARRAY_COM01', 'script', NULL),
(803, 'front_err_ARRAY_COM02', 'arrays', 'front_err_ARRAY_COM02', 'script', NULL),
(804, 'front_err_ARRAY_COM03', 'arrays', 'front_err_ARRAY_COM03', 'script', NULL),
(805, 'lblFilesUploadedToday', 'backend', 'Label / files uploaded today', 'script', NULL),
(806, 'lblFileUploadedToday', 'backend', 'Label / file uploaded today', 'script', NULL),
(807, 'lblCommentsPostedToday', 'backend', 'Label / comments posted today', 'script', NULL),
(808, 'lblCommentPostedToday', 'backend', 'Label / comment posted today', 'script', NULL),
(809, 'lblClientsAddedToday', 'backend', 'Label / clients added today', 'script', NULL),
(810, 'lblClientAddedToday', 'backend', 'Label / client added today', 'script', NULL),
(811, 'lblLastUploadedFiles', 'backend', 'Label / Last uploaded files', 'script', NULL),
(812, 'lblLatestComments', 'backend', 'Label / Latest comments', 'script', NULL),
(813, 'lblQuickLinks', 'backend', 'Label / Quick links', 'script', NULL),
(814, 'lblNoFilesFound', 'backend', 'Label / No files found.', 'script', NULL),
(815, 'lblNoCommentsFound', 'backend', 'Label / No comments found.', 'script', NULL),
(816, 'lblAddNewClient', 'backend', 'Label / Add new client', 'script', NULL),
(817, 'lblUploadAFile', 'backend', 'Label / Upload a file', 'script', NULL),
(818, 'lblAddAComment', 'backend', 'Label / Add a comment', 'script', NULL),
(819, 'lblFileUploaded', 'backend', 'Label / file uploaded', 'script', NULL),
(820, 'lblFilesUploaded', 'backend', 'Label / files uploaded', 'script', NULL),
(821, 'lblCommentsPosted', 'backend', 'Label / comments posted', 'script', NULL),
(822, 'lblCommentPosted', 'backend', 'Label / comment posted', 'script', NULL),
(823, 'lblSpaceTaken', 'backend', 'Label / Space taken', 'script', NULL),
(824, 'lblAllFiles', 'backend', 'Label / All files', 'script', NULL),
(825, 'lblNA', 'backend', 'Label / n/a', 'script', NULL),
(826, 'lblDeleteComment', 'backend', 'Label / Delete comment', 'script', NULL),
(827, 'lblDeleteCommentConfirmation', 'backend', 'Label / Delete comment', 'script', NULL),
(828, 'buttons_ARRAY_delete', 'arrays', 'buttons_ARRAY_delete', 'script', NULL),
(829, 'buttons_ARRAY_cancel', 'arrays', 'buttons_ARRAY_cancel', 'script', NULL),
(830, 'front_label_allowed_extensions', 'frontend', 'Label / Allowed file extensions', 'script', NULL),
(831, 'front_label_max_file_size', 'frontend', 'Label / Max upload file size:', 'script', NULL),
(832, 'front_err_ARRAY_FF03', 'arrays', 'front_err_msg_ARRAY_FF03', 'script', NULL),
(833, 'front_err_ARRAY_FF04', 'arrays', 'front_err_msg_ARRAY_FF04', 'script', NULL),
(834, 'file_error_code_ARRAY_101', 'arrays', 'file_error_code_ARRAY_101', 'script', NULL),
(835, 'file_error_code_ARRAY_102', 'arrays', 'file_error_code_ARRAY_102', 'script', NULL),
(836, 'file_error_code_ARRAY_121', 'arrays', 'file_error_code_ARRAY_121', 'script', NULL),
(837, 'file_error_code_ARRAY_122', 'arrays', 'file_error_code_ARRAY_122', 'script', NULL),
(838, 'file_error_code_ARRAY_123', 'arrays', 'file_error_code_ARRAY_123', 'script', NULL),
(839, 'file_error_code_ARRAY_100', 'arrays', 'file_error_code_ARRAY_100', 'script', NULL),
(840, 'lblDownloadSelected', 'backend', 'Label / Download selected', 'script', NULL),
(841, 'front_label_post_max_size', 'backend', 'Label / Post max size', 'script', NULL);

INSERT INTO `filesharing_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Add language', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 5, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 6, 'pjField', 1, 'title', '', 'script'),
(NULL, 7, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 9, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 10, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Next ', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 34, 'pjField', 1, 'title', '', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Location and address', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Listing Bookings Body', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Listing Bookings Title', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Listing Contact Body', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Listing Contact Title', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'Extend exp.date Body', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Extend exp.date Title', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Listing Prices Body', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Listing Prices Title', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Languages Array Body', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Languages Arrays Title', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Languages Backend Body', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Languages Backend Title', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Languages Body', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Languages Frontend Body', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Languages Frontend Title', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Languages Title', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Backup database', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Backup files', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'User with such email address exists.', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'Client with such email address exists.', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'List of users', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'Below you can see users who have access to the Menu Builder administration pages. There are two types of users Administrators and Editors only. Click on "+ Add user" button to add a new user.', 'script'),
(NULL, 482, 'pjField', 1, 'title', '+ Add user', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'No records selected', 'script'),
(NULL, 484, 'pjField', 1, 'title', 'You need to select at least a single record.', 'script'),
(NULL, 485, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 486, 'pjField', 1, 'title', 'You can add administrator user who has full access to administration page or add an editor user who will only be able to access categories, products, offers and will not be able to modify options, other users.', 'script'),
(NULL, 487, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 488, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 489, 'pjField', 1, 'title', 'You can make any change on the form below and click "Save" button to update user information.', 'script'),
(NULL, 490, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 491, 'pjField', 1, 'title', 'General options', 'script'),
(NULL, 492, 'pjField', 1, 'title', 'Here you can set the General options for the Menu Builder.', 'script'),
(NULL, 493, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 595, 'pjField', 1, 'title', 'Clients', 'script'),
(NULL, 596, 'pjField', 1, 'title', 'Files', 'script'),
(NULL, 597, 'pjField', 1, 'title', 'Comments', 'script'),
(NULL, 598, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 599, 'pjField', 1, 'title', 'To clients', 'script'),
(NULL, 600, 'pjField', 1, 'title', 'To administrators', 'script'),
(NULL, 601, 'pjField', 1, 'title', 'Comments order', 'script'),
(NULL, 602, 'pjField', 1, 'title', 'Comments per page', 'script'),
(NULL, 603, 'pjField', 1, 'title', 'File with extension is allowed to upload. ', 'script'),
(NULL, 604, 'pjField', 1, 'title', 'Banned words', 'script'),
(NULL, 605, 'pjField', 1, 'title', 'You can make a list of words (separated by commas) and comments containing any of these words will not be allowed.', 'script'),
(NULL, 606, 'pjField', 1, 'title', 'General options', 'script'),
(NULL, 607, 'pjField', 1, 'title', 'Here you can set the General options for the system.', 'script'),
(NULL, 608, 'pjField', 1, 'title', 'New on top', 'script'),
(NULL, 609, 'pjField', 1, 'title', 'New at bottom', 'script'),
(NULL, 610, 'pjField', 1, 'title', 'PHP mail()', 'script'),
(NULL, 611, 'pjField', 1, 'title', 'SMTP', 'script'),
(NULL, 612, 'pjField', 1, 'title', 'Notifications sent to clients', 'script'),
(NULL, 613, 'pjField', 1, 'title', 'Different email notifications will be sent to clients when various events occur.', 'script'),
(NULL, 614, 'pjField', 1, 'title', 'New file notification', 'script'),
(NULL, 615, 'pjField', 1, 'title', 'New comment notification', 'script'),
(NULL, 616, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 617, 'pjField', 1, 'title', 'Message', 'script'),
(NULL, 618, 'pjField', 1, 'title', 'Sms notifications sent to clients', 'script'),
(NULL, 619, 'pjField', 1, 'title', 'Different SMS notifications will be sent to clients when various events occur. Under SMS tab you need to input your API key for our SMS gateway.', 'script'),
(NULL, 620, 'pjField', 1, 'title', 'New file posted', 'script'),
(NULL, 621, 'pjField', 1, 'title', 'New comment posted', 'script'),
(NULL, 622, 'pjField', 1, 'title', 'Notifications sent to administrators', 'script'),
(NULL, 623, 'pjField', 1, 'title', 'Set the automated email notifications sent to the script admins when new file or comment posted.', 'script'),
(NULL, 624, 'pjField', 1, 'title', 'Sms sent to administrators', 'script'),
(NULL, 625, 'pjField', 1, 'title', 'Different SMS notifications will be sent to administrators when new file or new comment posted. Under SMS tab you need to input your API key for our SMS gateway.', 'script'),
(NULL, 626, 'pjField', 1, 'title', 'Available tokens:<br/>\r\n[FileSection]...[/FileSection]<br/>\r\n{FileName}<br/>\r\n{FileSize}<br/>\r\n{Client}', 'script'),
(NULL, 627, 'pjField', 1, 'title', 'Available tokens:<br/>\r\n{CommentID}<br/>\r\n{Comment}<br/>\r\n{FileName}<br/>\r\n{Client}', 'script'),
(NULL, 628, 'pjField', 1, 'title', 'Notifications updated!', 'script'),
(NULL, 629, 'pjField', 1, 'title', 'Changes made to email and sms notifications have been saved.', 'script'),
(NULL, 630, 'pjField', 1, 'title', 'Client updated!', 'script'),
(NULL, 631, 'pjField', 1, 'title', 'Changes made to the client have been saved.', 'script'),
(NULL, 632, 'pjField', 1, 'title', 'Client added!', 'script'),
(NULL, 633, 'pjField', 1, 'title', 'New client has been added into the system.', 'script'),
(NULL, 634, 'pjField', 1, 'title', 'Client not added!', 'script'),
(NULL, 635, 'pjField', 1, 'title', 'Client could not be added. Please try again.', 'script'),
(NULL, 636, 'pjField', 1, 'title', 'Client not found!', 'script'),
(NULL, 637, 'pjField', 1, 'title', 'Client you are looking for is missing. Please try again.', 'script'),
(NULL, 638, 'pjField', 1, 'title', 'List of clients', 'script'),
(NULL, 639, 'pjField', 1, 'title', 'You can find below the list of clients. If you want to add new client, click on the button "+ Add client". You can also click on the pencil icon on the corresponding entry to view more details about the selected client.', 'script'),
(NULL, 640, 'pjField', 1, 'title', '+ Add client', 'script'),
(NULL, 641, 'pjField', 1, 'title', 'Add client', 'script'),
(NULL, 642, 'pjField', 1, 'title', 'Fill in the form below and click "Save" button to add new client.', 'script'),
(NULL, 643, 'pjField', 1, 'title', 'Update client', 'script'),
(NULL, 644, 'pjField', 1, 'title', 'You can make any changes on the form below and click on "Save" button to update client information.', 'script'),
(NULL, 645, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 646, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 647, 'pjField', 1, 'title', 'Email is already used.', 'script'),
(NULL, 648, 'pjField', 1, 'title', 'List of files', 'script'),
(NULL, 649, 'pjField', 1, 'title', 'You can see below the list of uploaded files. If you want to add files, click on the button "+ Add file(s)".', 'script'),
(NULL, 650, 'pjField', 1, 'title', '+ Add file(s)', 'script'),
(NULL, 651, 'pjField', 1, 'title', 'File name', 'script'),
(NULL, 652, 'pjField', 1, 'title', 'File size', 'script'),
(NULL, 653, 'pjField', 1, 'title', 'Uploaded', 'script'),
(NULL, 654, 'pjField', 1, 'title', 'Last comment', 'script'),
(NULL, 655, 'pjField', 1, 'title', 'Select clients', 'script'),
(NULL, 656, 'pjField', 1, 'title', 'File with extension is not allowed to upload.', 'script'),
(NULL, 657, 'pjField', 1, 'title', 'Add file(s)', 'script'),
(NULL, 658, 'pjField', 1, 'title', 'On the form below, you can upload one or more files and assign to one or more clients as you want.', 'script'),
(NULL, 659, 'pjField', 1, 'title', 'File(s)', 'script'),
(NULL, 660, 'pjField', 1, 'title', 'Client(s)', 'script'),
(NULL, 661, 'pjField', 1, 'title', 'There is no available clients now. To add new client click {STAG}here{ETAG}.', 'script'),
(NULL, 662, 'pjField', 1, 'title', 'File updated!', 'script'),
(NULL, 663, 'pjField', 1, 'title', 'Changes made to the file have been saved.', 'script'),
(NULL, 664, 'pjField', 1, 'title', 'File(s) added!', 'script'),
(NULL, 665, 'pjField', 1, 'title', 'New file(s) has/have been added into the system.', 'script'),
(NULL, 666, 'pjField', 1, 'title', 'File too big!', 'script'),
(NULL, 667, 'pjField', 1, 'title', 'File(s) could not be upload because the file size is too big. Maximum allowed size is {SIZE}. Please, upload another file.', 'script'),
(NULL, 668, 'pjField', 1, 'title', 'File not found!', 'script'),
(NULL, 669, 'pjField', 1, 'title', 'File you are looking for is missing. Please try again.', 'script'),
(NULL, 670, 'pjField', 1, 'title', 'File(s) error!', 'script'),
(NULL, 671, 'pjField', 1, 'title', 'File(s) could not be uploaded because of some error(s) occurred with file(s).', 'script'),
(NULL, 672, 'pjField', 1, 'title', 'File(s) could not be uploaded because there is/are some file(s) having file extensions not allowed to upload. Please check again.', 'script'),
(NULL, 673, 'pjField', 1, 'title', 'File extension not allowed!', 'script'),
(NULL, 674, 'pjField', 1, 'title', 'File error!', 'script'),
(NULL, 675, 'pjField', 1, 'title', 'File could not be uploaded because of some error occurred. Please check again.', 'script'),
(NULL, 676, 'pjField', 1, 'title', 'File could not be uploaded because file extension is not allowed to upload. Please check again.', 'script'),
(NULL, 677, 'pjField', 1, 'title', 'File extension not allowed!', 'script'),
(NULL, 685, 'pjField', 1, 'title', 'Update file', 'script'),
(NULL, 686, 'pjField', 1, 'title', 'You can make changes on the form below and click "Save" button to update file.', 'script'),
(NULL, 687, 'pjField', 1, 'title', 'File', 'script'),
(NULL, 688, 'pjField', 1, 'title', 'Current file', 'script'),
(NULL, 689, 'pjField', 1, 'title', 'File not found.', 'script'),
(NULL, 690, 'pjField', 1, 'title', 'Hash value does not match.', 'script'),
(NULL, 691, 'pjField', 1, 'title', 'Approved', 'script'),
(NULL, 692, 'pjField', 1, 'title', 'Not approved', 'script'),
(NULL, 693, 'pjField', 1, 'title', 'List of comments', 'script'),
(NULL, 694, 'pjField', 1, 'title', 'You can see below the list of comments. If you want to view more details about a specific comment, click on the pencil icon on the corresponding entry.', 'script'),
(NULL, 695, 'pjField', 1, 'title', 'Posted by', 'script'),
(NULL, 696, 'pjField', 1, 'title', 'Comment', 'script'),
(NULL, 697, 'pjField', 1, 'title', '+ Add comment', 'script'),
(NULL, 698, 'pjField', 1, 'title', 'Add comment', 'script'),
(NULL, 699, 'pjField', 1, 'title', 'Fill in the form below and click "Save" button to add new comment.', 'script'),
(NULL, 700, 'pjField', 1, 'title', 'Comment updated!', 'script'),
(NULL, 701, 'pjField', 1, 'title', 'Changes made to the comment have been saved.', 'script'),
(NULL, 702, 'pjField', 1, 'title', 'Comment added!', 'script'),
(NULL, 703, 'pjField', 1, 'title', 'New comment has been added into the system.', 'script'),
(NULL, 704, 'pjField', 1, 'title', 'Comment not added!', 'script'),
(NULL, 705, 'pjField', 1, 'title', 'Comment could not be added. Please try again.', 'script'),
(NULL, 706, 'pjField', 1, 'title', 'Comment not found!', 'script'),
(NULL, 707, 'pjField', 1, 'title', 'Comment you are looking is missing. Please try again.', 'script'),
(NULL, 708, 'pjField', 1, 'title', 'Update comment', 'script'),
(NULL, 709, 'pjField', 1, 'title', 'You can make any changes on the form below and click "Save" button to update comment.', 'script'),
(NULL, 710, 'pjField', 1, 'title', 'Client', 'script'),
(NULL, 711, 'pjField', 1, 'title', 'User', 'script'),
(NULL, 713, 'pjField', 1, 'title', 'Administrator', 'script'),
(NULL, 714, 'pjField', 1, 'title', 'Uploaded by', 'script'),
(NULL, 715, 'pjField', 1, 'title', 'on', 'script'),
(NULL, 716, 'pjField', 1, 'title', 'Install & Preview', 'script'),
(NULL, 717, 'pjField', 1, 'title', 'Theme', 'script'),
(NULL, 718, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 719, 'pjField', 1, 'title', 'Get Install Code', 'script'),
(NULL, 720, 'pjField', 1, 'title', 'Install code', 'script'),
(NULL, 721, 'pjField', 1, 'title', 'Select the theme you need to use and then either preview it or get its installation code. You need to put the PHP code a .php page.', 'script'),
(NULL, 722, 'pjField', 1, 'title', 'Select theme', 'script'),
(NULL, 723, 'pjField', 1, 'title', 'Step 1. Copy and paste following code at very top of your page, before any other code.', 'script'),
(NULL, 724, 'pjField', 1, 'title', 'Step 2. Copy and paste following code inside your html code, where the File Sharing list will be displayed.', 'script'),
(NULL, 725, 'pjField', 1, 'title', 'Step 3. Copy and paste following code at very bottom of your page, after all the code.', 'script'),
(NULL, 726, 'pjField', 1, 'title', '+ Add file', 'script'),
(NULL, 727, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 728, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 729, 'pjField', 1, 'title', 'Sort by', 'script'),
(NULL, 730, 'pjField', 1, 'title', 'date', 'script'),
(NULL, 731, 'pjField', 1, 'title', 'File name', 'script'),
(NULL, 732, 'pjField', 1, 'title', 'Size', 'script'),
(NULL, 733, 'pjField', 1, 'title', 'Date uploaded', 'script'),
(NULL, 734, 'pjField', 1, 'title', 'Last comment', 'script'),
(NULL, 735, 'pjField', 1, 'title', 'View as', 'script'),
(NULL, 736, 'pjField', 1, 'title', 'Grid', 'script'),
(NULL, 737, 'pjField', 1, 'title', 'Table', 'script'),
(NULL, 738, 'pjField', 1, 'title', 'Login to your account', 'script'),
(NULL, 739, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.', 'script'),
(NULL, 740, 'pjField', 1, 'title', 'Email address', 'script'),
(NULL, 741, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 742, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 743, 'pjField', 1, 'title', 'Please enter a valid email.', 'script'),
(NULL, 744, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 745, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 746, 'pjField', 1, 'title', 'Forgot your password?', 'script'),
(NULL, 747, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.', 'script'),
(NULL, 748, 'pjField', 1, 'title', 'Send new password', 'script'),
(NULL, 749, 'pjField', 1, 'title', 'Email address is missing.', 'script'),
(NULL, 750, 'pjField', 1, 'title', 'Email address cannot be empty.', 'script'),
(NULL, 751, 'pjField', 1, 'title', 'Email address is invalid.', 'script'),
(NULL, 752, 'pjField', 1, 'title', 'Password is missing.', 'script'),
(NULL, 753, 'pjField', 1, 'title', 'Password cannot be empty.', 'script'),
(NULL, 754, 'pjField', 1, 'title', 'Your account does not exist.', 'script'),
(NULL, 755, 'pjField', 1, 'title', 'Your account is already disabled.', 'script'),
(NULL, 756, 'pjField', 1, 'title', 'Forgot  password notification', 'script'),
(NULL, 757, 'pjField', 1, 'title', 'Available tokens:<br/>\r\n{Name}<br/>\r\n{Password}', 'script'),
(NULL, 758, 'pjField', 1, 'title', 'Email address is missing.', 'script'),
(NULL, 759, 'pjField', 1, 'title', 'Email address cannot be empty.', 'script'),
(NULL, 760, 'pjField', 1, 'title', 'Email address is invalid.', 'script'),
(NULL, 761, 'pjField', 1, 'title', 'Your account is already disabled.', 'script'),
(NULL, 762, 'pjField', 1, 'title', 'The password was already sent to your email.', 'script'),
(NULL, 763, 'pjField', 1, 'title', 'Files', 'script'),
(NULL, 764, 'pjField', 1, 'title', 'My profile', 'script'),
(NULL, 765, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 766, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 767, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 768, 'pjField', 1, 'title', 'Your profile has been updated.', 'script'),
(NULL, 769, 'pjField', 1, 'title', 'Upload', 'script'),
(NULL, 770, 'pjField', 1, 'title', 'Remove files', 'script'),
(NULL, 771, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do', 'script'),
(NULL, 772, 'pjField', 1, 'title', 'You can only upload {EXT} files.', 'script'),
(NULL, 773, 'pjField', 1, 'title', 'File(s) has/have been uploaded successfully.', 'script'),
(NULL, 774, 'pjField', 1, 'title', 'Some error occurred with uploaded files. Please check again.', 'script'),
(NULL, 775, 'pjField', 1, 'title', 'You can only upload {EXT} files.', 'script'),
(NULL, 776, 'pjField', 1, 'title', 'Files per page', 'script'),
(NULL, 777, 'pjField', 1, 'title', 'Files not found.', 'script'),
(NULL, 778, 'pjField', 1, 'title', 'prev', 'script'),
(NULL, 779, 'pjField', 1, 'title', 'next', 'script'),
(NULL, 780, 'pjField', 1, 'title', 'Details', 'script'),
(NULL, 781, 'pjField', 1, 'title', 'Comments', 'script'),
(NULL, 782, 'pjField', 1, 'title', 'You can fine below the list of comments posted for the selected file. You can post your reply to the comments via filling in the form at the bottom.', 'script'),
(NULL, 783, 'pjField', 1, 'title', 'Fill in the form below and click "Save" button to add new comment for the selected file.', 'script'),
(NULL, 784, 'pjField', 1, 'title', 'last uploaded {FILENAME} on {DATETIME}', 'script'),
(NULL, 786, 'pjField', 1, 'title', 'last comment on {DATETIME}', 'script'),
(NULL, 787, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 788, 'pjField', 1, 'title', 'Reply to comment', 'script'),
(NULL, 789, 'pjField', 1, 'title', 'by', 'script'),
(NULL, 790, 'pjField', 1, 'title', 'Replace file', 'script'),
(NULL, 791, 'pjField', 1, 'title', 'Favorite on top', 'script'),
(NULL, 792, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 793, 'pjField', 1, 'title', 'Uploaded on', 'script'),
(NULL, 794, 'pjField', 1, 'title', 'Uploaded by', 'script'),
(NULL, 795, 'pjField', 1, 'title', 'File size', 'script'),
(NULL, 796, 'pjField', 1, 'title', 'Comments', 'script'),
(NULL, 797, 'pjField', 1, 'title', 'No comments found.', 'script'),
(NULL, 798, 'pjField', 1, 'title', 'Leave a comment', 'script'),
(NULL, 799, 'pjField', 1, 'title', 'Your message', 'script'),
(NULL, 800, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 801, 'pjField', 1, 'title', 'Your comment has been posted successfully.', 'script'),
(NULL, 802, 'pjField', 1, 'title', 'Your message is missing.', 'script'),
(NULL, 803, 'pjField', 1, 'title', 'Your message cannot be empty.', 'script'),
(NULL, 804, 'pjField', 1, 'title', 'You comment could not be added properly. Please try again.', 'script'),
(NULL, 805, 'pjField', 1, 'title', 'files uploaded today', 'script'),
(NULL, 806, 'pjField', 1, 'title', 'file uploaded today', 'script'),
(NULL, 807, 'pjField', 1, 'title', 'comments posted today', 'script'),
(NULL, 808, 'pjField', 1, 'title', 'comment posted today', 'script'),
(NULL, 809, 'pjField', 1, 'title', 'clients added today', 'script'),
(NULL, 810, 'pjField', 1, 'title', 'client added today', 'script'),
(NULL, 811, 'pjField', 1, 'title', 'Last uploaded files', 'script'),
(NULL, 812, 'pjField', 1, 'title', 'Latest comments', 'script'),
(NULL, 813, 'pjField', 1, 'title', 'Quick links', 'script'),
(NULL, 814, 'pjField', 1, 'title', 'No files found.', 'script'),
(NULL, 815, 'pjField', 1, 'title', 'No comments found.', 'script'),
(NULL, 816, 'pjField', 1, 'title', 'Add new client', 'script'),
(NULL, 817, 'pjField', 1, 'title', 'Upload a file', 'script'),
(NULL, 818, 'pjField', 1, 'title', 'Add a comment', 'script'),
(NULL, 819, 'pjField', 1, 'title', 'file uploaded', 'script'),
(NULL, 820, 'pjField', 1, 'title', 'files uploaded', 'script'),
(NULL, 821, 'pjField', 1, 'title', 'comments posted', 'script'),
(NULL, 822, 'pjField', 1, 'title', 'comment posted', 'script'),
(NULL, 823, 'pjField', 1, 'title', 'Space taken', 'script'),
(NULL, 824, 'pjField', 1, 'title', 'All files', 'script'),
(NULL, 825, 'pjField', 1, 'title', 'n/a', 'script'),
(NULL, 826, 'pjField', 1, 'title', 'Delete comment', 'script'),
(NULL, 827, 'pjField', 1, 'title', 'Are you sure to delete this comment?', 'script'),
(NULL, 828, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 829, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 830, 'pjField', 1, 'title', 'Allowed file extensions: {EXT}', 'script'),
(NULL, 831, 'pjField', 1, 'title', 'Maximum allowed size for uploaded files: {MAX}', 'script'),
(NULL, 832, 'pjField', 1, 'title', 'File(s) could not be upload because the file size is too big. Maximum allowed size is {SIZE}.', 'script'),
(NULL, 833, 'pjField', 1, 'title', 'Some files were uploaded, but there are also some error files.', 'script'),
(NULL, 834, 'pjField', 1, 'title', 'File extension not supported', 'script'),
(NULL, 835, 'pjField', 1, 'title', 'Mime type not supported.', 'script'),
(NULL, 836, 'pjField', 1, 'title', 'File size exceeds', 'script'),
(NULL, 837, 'pjField', 1, 'title', 'File size exceeds', 'script'),
(NULL, 838, 'pjField', 1, 'title', 'Uploaded partially', 'script'),
(NULL, 839, 'pjField', 1, 'title', 'Uploaded', 'script'),
(NULL, 840, 'pjField', 1, 'title', 'Download selected', 'script'),
(NULL, 841, 'pjField', 1, 'title', 'Maximum size of POST data that PHP will accept: {MAX}', 'script');

INSERT INTO `filesharing_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 2, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 3, 1, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 4, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 5, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 6, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 7, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 8, 1, NULL),
(1, 'o_theme', 1, 'theme1|theme2|theme3|theme4|theme5|theme6|theme7|theme8|theme9|theme10::theme1', 'Theme 1|Theme 2|Theme 3|Theme 4|Theme 5|Theme 6|Theme 7|Theme 8|Theme 9|Theme 10', 'enum', 10, 1, NULL),
(1, 'o_files_per_page', 1, '10', NULL, 'int', 11, 1, NULL),
(1, 'o_comments_order', 1, 'new_on_top|new_at_bottom::new_on_top', 'New on top|New at bottom', 'enum', 12, 0, NULL),
(1, 'o_comments_per_page', 1, '5', NULL, 'int', 13, 1, NULL),
(1, 'o_file_allowed', 1, 'pdf|doc|docx|xls|csv|txt|rtf|zip|mp3|wma|mpg|flv|avi|jpg|jpeg|png|gif', NULL, 'text', 14, 1, NULL),
(1, 'o_banned_words', 1, '', NULL, 'text', 15, 0, NULL),

(1, 'o_email_new_comment_subject', 2, '', NULL, 'string', 5, 1, NULL),
(1, 'o_email_new_comment_message', 2, '', NULL, 'text', 6, 1, NULL),
(1, 'o_email_new_file_subject', 2, '', NULL, 'string', 7, 1, NULL),
(1, 'o_email_new_file_message', 2, '', NULL, 'text', 8, 1, NULL),
(1, 'o_email_forgot_subject', 2, '', NULL, 'string', 9, 1, NULL),
(1, 'o_email_forgot_message', 2, '', NULL, 'text', 10, 1, NULL),

(1, 'o_sms_new_comment', 2, '', NULL, 'text', 11, 1, NULL),
(1, 'o_sms_new_file', 2, '', NULL, 'text', 12, 1, NULL),

(1, 'o_admin_email_new_comment_subject', 3, '', NULL, 'string', 5, 1, NULL),
(1, 'o_admin_email_new_comment_message', 3, '', NULL, 'text', 6, 1, NULL),
(1, 'o_admin_email_new_file_subject', 3, '', NULL, 'string', 7, 1, NULL),
(1, 'o_admin_email_new_file_message', 3, '', NULL, 'text', 8, 1, NULL),

(1, 'o_admin_sms_new_comment', 3, '', NULL, 'text', 9, 1, NULL),
(1, 'o_admin_sms_new_file', 3, '', NULL, 'text', 10, 1, NULL),

(1, 'o_multi_lang', 99, '1|0::0', 'Yes|No', 'enum', NULL, 0, NULL),
(1, 'o_fields_index', 99, 'd874fcc5fe73b90d770a544664a3775d', NULL, 'string', NULL, 0, NULL);

INSERT INTO `filesharing_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');

COMMIT;