<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}

class pjAdminClients extends pjAdmin
{
	public function pjActionCheckEmail()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (!isset($_GET['email']) || empty($_GET['email']))
			{
				echo 'false';
				exit;
			}
			$pjClientModel = pjClientModel::factory()->where('t1.email', $_GET['email']);
			if (isset($_GET['id']) && (int) $_GET['id'] > 0)
			{
				$pjClientModel->where('t1.id !=', $_GET['id']);
			}
			echo $pjClientModel->findCount()->getData() == 0 ? 'true' : 'false';
		}
		exit;
	}

	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['client_create']))
			{
				$data = array();
				$data['password'] = pjUtil::getRandomPassword();
				$id = pjClientModel::factory()->setAttributes(array_merge($_POST, $data))->insert()->getInsertId();
				
				if ($id !== false && (int) $id > 0)
				{
					$err = 'ACL03';
				} else {
					$err = 'ACL04';
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminClients&action=pjActionIndex&err=$err");
			} else {
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminClients.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionDeleteClient()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			if (pjClientModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				pjClientFileModel::factory()->whereIn('client_id', $_GET['id'])->eraseAll();
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteClientBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjClientModel::factory()->reset()->whereIn('id', $_POST['record'])->eraseAll();
				pjClientFileModel::factory()->whereIn('client_id', $_POST['record'])->eraseAll();
			}
		}
		exit;
	}
	
	public function pjActionExportClient()
	{
		$this->checkLogin();
		
		if (isset($_POST['record']) && is_array($_POST['record']))
		{
			$arr = pjClientModel::factory()->select('t1.id, t1.name, t1.email, t1.phone, t1.status')->whereIn('id', $_POST['record'])->findAll()->getData();
			$csv = new pjCSV();
			$csv
				->setHeader(true)
				->setName("Clients-".time().".csv")
				->process($arr)
				->download();
		}
		exit;
	}
	
	public function pjActionGetClient()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjClientModel = pjClientModel::factory();
			
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjClientModel->where('t1.email LIKE', "%$q%");
				$pjClientModel->orWhere('t1.name LIKE', "%$q%");
				$pjClientModel->orWhere('t1.phone LIKE', "%$q%");
			}

			if (isset($_GET['status']) && !empty($_GET['status']) && in_array($_GET['status'], array('T', 'F')))
			{
				$pjClientModel->where('t1.status', $_GET['status']);
			}
				
			$column = 'name';
			$direction = 'ASC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjClientModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}
			$data = $pjClientModel
				->select(sprintf("t1.*, AES_DECRYPT(t1.password, '%1\$s') AS `password`,
						(SELECT TC.created FROM `%2\$s` AS TC WHERE TC.client_id=t1.id AND TC.file_id IN (SELECT TCF.file_id FROM `%3\$s` AS TCF WHERE TCF.client_id=t1.id ) ORDER BY TC.created DESC LIMIT 1 ) as last_comment,
						(SELECT COUNT(*) FROM `%4\$s` AS t2 WHERE t2.client_id = t1.id) as cnt_files", PJ_SALT, pjCommentModel::factory()->getTable(), pjClientFileModel::factory()->getTable(), pjClientFileModel::factory()->getTable()))
				->orderBy("$column $direction")
				->limit($rowCount, $offset)
				->findAll()->getData();
			
			foreach($data as $k => $v)
			{
				if(!empty($v['last_comment']))
				{
					$v['last_comment'] = date($this->option_arr['o_date_format'], strtotime($v['last_comment'])) . ', ' . date($this->option_arr['o_time_format'], strtotime($v['last_comment']));
				}else{
					$v['last_comment'] = __('lblNA', true);
				}
				$data[$k] = $v;
			}
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
	
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminClients.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionSaveClient()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			pjClientModel::factory()->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
				
			if (isset($_POST['client_update']))
			{
				pjClientModel::factory()->where('id', $_POST['id'])->limit(1)->modifyAll($_POST);
				
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminClients&action=pjActionIndex&err=ACL01");
				
			} else {
				$pjClientModel = pjClientModel::factory();
				$arr = $pjClientModel
					->select("t1.*, AES_DECRYPT(t1.password, '".PJ_SALT."') AS `password`,
						(SELECT COUNT(*) FROM `".pjClientFileModel::factory()->getTable()."` AS t2 WHERE t2.client_id = t1.id) as cnt_files,
						(SELECT CONCAT(t3.created, '~:~',CONCAT(t3.file_name, '~:~', CONCAT(t3.id, '~:~', t3.hash))) FROM `".pjFileModel::factory()->getTable()."` AS t3 WHERE t3.id IN(SELECT TCF.file_id FROM `".pjClientFileModel::factory()->getTable()."` AS TCF WHERE TCF.client_id=t1.id) ORDER BY created DESC LIMIT 1) as last_uploaded,
						(SELECT COUNT(*) FROM `".pjCommentModel::factory()->getTable()."` AS t4 WHERE t4.client_id = t1.id) as cnt_comments,
						(SELECT CONCAT(t5.created, '~:~', t5.id) FROM `".pjCommentModel::factory()->getTable()."` AS t5 WHERE t5.client_id = t1.id ORDER BY created DESC LIMIT 1) as last_comment")
					->find($_GET['id'])
					->getData();
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminClients&action=pjActionIndex&err=ACL08");
				}
				$this->set('arr', $arr);
								
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminClients.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
}
?>