<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminComments extends pjAdmin
{
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['comment_create']))
			{
				$data = array();
				$data['ip'] = pjUtil::getClientIp();
				if($_POST['postedby'] == 'user')
				{
					unset($_POST['client_id']);
					$data['client_id'] = ':NULL';
				}
				if($_POST['postedby'] == 'client')
				{
					unset($_POST['user_id']);
					$data['user_id'] = ':NULL';
				}
				
				$id = pjCommentModel::factory(array_merge($_POST, $data))->insert()->getInsertId();
				
				if ($id !== false && (int) $id > 0)
				{
					$client_id_arr = pjClientFileModel::factory()->where('t1.file_id', $_POST['file_id'])->findAll()->getDataPair(null, 'client_id');
					if(!empty($client_id_arr))
					{
						$arr = pjCommentModel::factory()
							->select('t1.*, t2.file_name')
							->join('pjFile', 't1.file_id=t2.id', 'left')
							->find($id)
							->getData();
						$client_arr = pjClientModel::factory()
							->whereIn('id', $client_id_arr)
							->findAll()
							->getData();
						foreach($client_arr as $client)
						{
							$this->newCommentEmail($client, $arr, $this->option_arr, 'client');
							$this->sendSMS($client, $this->option_arr, 'comment', 'client');
						}
					}
					$err = 'AC03';
				} else {
					$err = 'AC04';
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminComments&action=pjActionIndex&err=$err");
			} else {

				$client_arr = pjClientModel::factory()->orderBy('t1.name ASC')->findAll()->getData();
				$user_arr = pjUserModel::factory()->orderBy('t1.name ASC')->findAll()->getData();
				$file_arr = pjFileModel::factory()->orderBy('t1.created DESC')->findAll()->getData();
				
				$this->set('file_arr', $file_arr);
				$this->set('client_arr', $client_arr);
				$this->set('user_arr', $user_arr);

				$this->appendJs('chosen.jquery.min.js', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendCss('chosen.css', PJ_THIRD_PARTY_PATH . 'chosen/');
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminComments.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionDeleteComment()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			if (pjCommentModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteCommentBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjCommentModel::factory()->whereIn('id', $_POST['record'])->eraseAll();
			}
		}
		exit;
	}
	
	public function pjActionExportComment()
	{
		$this->checkLogin();
		
		if (isset($_POST['record']) && is_array($_POST['record']))
		{
			$arr = pjCommentModel::factory()
				->select('t1.*, t2.name as user, t3.name as client, t3.file_name')
				->join('pjUser', 't1.user_id=t2.id', 'left')
				->join('pjClient', 't1.client_id=t2.id', 'left')
				->join('pjFile', 't1.file_id=t3.id', 'left')
				->whereIn('id', $_POST['record'])
				->findAll()
				->getData();
			$csv = new pjCSV();
			$csv
				->setHeader(true)
				->setName("Comments-".time().".csv")
				->process($arr)
				->download();
		}
		exit;
	}
	
	public function pjActionGetComment()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjCommentModel = pjCommentModel::factory();
			
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjCommentModel->where("(t1.comment LIKE '%$q%'");
			}

			if (isset($_GET['status']) && !empty($_GET['status']) && in_array($_GET['status'], array('T', 'F')))
			{
				$pjCommentModel->where('t1.status', $_GET['status']);
			}
			if (isset($_GET['file_id']))
			{
				$pjCommentModel->where('t1.file_id', $_GET['file_id']);
			}
			if (isset($_GET['client_id']))
			{
				$pjCommentModel->where('t1.client_id', $_GET['client_id']);
			}
				
			$column = 't1.created';
			$direction = 'DESC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}
			$total = $pjCommentModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}
			$data = array();
			$arr = $pjCommentModel
				->select("t1.id, t1.file_id, t1.client_id, t1.status, t1.created, t2.name AS client, t3.name AS user, t4.file_name, t4.hash,
						(IF(CHAR_LENGTH(t1.comment) >= 60, CONCAT(SUBSTRING(t1.comment, 1, 60), ' ...'), t1.comment)) as comment")
				->join('pjClient', 't2.id=t1.client_id', 'left')
				->join('pjUser', 't3.id=t1.user_id', 'left')
				->join('pjFile', 't4.id=t1.file_id', 'left')
				->orderBy("$column $direction")
				->limit($rowCount, $offset)
				->findAll()->getData();

			foreach($arr as $k => $v)
			{
			    $v['comment'] = pjSanitize::clean($v['comment']);
				$v['created'] = date($this->option_arr['o_date_format'], strtotime($v['created'])) . ', ' . date($this->option_arr['o_time_format'], strtotime($v['created']));
				$data[$k] = $v;
			}	
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
	
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminComments.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionSaveComment()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjCommentModel = pjCommentModel::factory();
	
			$pjCommentModel->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
			
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['comment_update']))
			{
				$data = array();
				$data['ip'] = pjUtil::getClientIp();
				$data['modified'] = date('Y-m-d H:i:s');
				if($_POST['postedby'] == 'user')
				{
					unset($_POST['client_id']);
					$data['client_id'] = ':NULL';
				}
				if($_POST['postedby'] == 'client')
				{
					unset($_POST['user_id']);
					$data['user_id'] = ':NULL';
				}
				pjCommentModel::factory()->where('id', $_POST['id'])->limit(1)->modifyAll(array_merge($_POST, $data));
								
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminComments&action=pjActionIndex&err=AC01");
				
			} else {
				
				$pjFileModel = pjFileModel::factory();
				$pjCommentModel = pjCommentModel::factory();
				
				$arr = $pjCommentModel
					->select('t1.*, t2.file_name, t2.hash')
					->join('pjFile', 't1.file_id=t2.id', 'left')
					->find($_GET['id'])
					->getData();
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminComments&action=pjActionIndex&err=AC08");
				}

				$client_arr = pjClientModel::factory()->orderBy('t1.name ASC')->findAll()->getData();
				$user_arr = pjUserModel::factory()->orderBy('t1.name ASC')->findAll()->getData();
				$file_arr = pjFileModel::factory()->orderBy('t1.created DESC')->findAll()->getData();
				
				$this->set('arr', $arr);
				$this->set('file_arr', $file_arr);
				$this->set('client_arr', $client_arr);
				$this->set('user_arr', $user_arr);
				
			
				$this->appendJs('chosen.jquery.min.js', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendCss('chosen.css', PJ_THIRD_PARTY_PATH . 'chosen/');
								
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminComments.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionGetFiles()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjFileModel = pjFileModel::factory();
			if(isset($_GET['client_id']) && (int) $_GET['client_id'] > 0)
			{
				$pjFileModel->where('t1.id IN (SELECT TCF.file_id FROM `'.pjClientFileModel::factory()->getTable().'` TCF WHERE TCF.client_id = '.$_GET['client_id'].')');
			}
			$file_arr = $pjFileModel->orderBy('t1.created DESC')->findAll()->getData();
			$this->set('file_arr', $file_arr);
		}
	}
}
?>