var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		var $frmCreateFile = $("#frmCreateFile"),
			$frmUpdateFile = $("#frmUpdateFile"),
			$frmPostComment = $('#frmPostComment'),
			$dialogDelete = $('#dialogDelete'),
			dialog = ($.fn.dialog !== undefined),
			multiselect = ($.fn.multiselect !== undefined),
			validate = ($.fn.validate !== undefined),
			datagrid = ($.fn.datagrid !== undefined);
		
		if (multiselect) {
			$("#client_id").multiselect({
				noneSelectedText: myLabel.select_clients
			});
		}
		
		if ($frmPostComment.length > 0 && validate) {
			$frmPostComment.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ''
			});
			
			$('#pjPcEditClient').hide();
			$('#pjPcEditFile').hide();
			$('#pjPcPreviewFile').hide();
		}
		
		if ($frmCreateFile.length > 0 && validate) 
		{
			$frmCreateFile.validate({
				rules: {
					"files[]":{
						extension: myLabel.allowed_extension
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ''
			});
		}
		if ($frmUpdateFile.length > 0 && validate) {
			$frmUpdateFile.validate({
				rules: {
					"file":{
						extension: myLabel.allowed_extension
					}
				},
				messages:{
					"file":{
						required: myLabel.field_required,
						extension: myLabel.extension_message
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em"
			});
		}
		
		if ($("#grid").length > 0 && datagrid) 
		{
			function formatFileName(val, obj) {
				return '<a href="file.php?id='+obj.id+'&hash='+obj.hash+'" target="_blank">' + val + '</a><br/>' + obj.file_size;
			}
			function formUploaded(val, obj) {
				if(obj.user_id != null)
				{
					if(pjGrid.roleId == 1)
					{
						return '<a href="index.php?controller=pjAdminUsers&action=pjActionUpdate&id='+obj.user_id+'">' + obj.user + '</a><br/>' + val;
					}else{
						return obj.user + '<br/>' + val;
					}
				}else{
					if(pjGrid.roleId == 1)
					{
						return '<a href="index.php?controller=pjAdminClients&action=pjActionUpdate&id='+obj.client_id+'">' + obj.client + '</a><br/>' + val;
					}else{
						return obj.client + '<br/>' + val;
					}
				}
			}
			function formatComments(val, obj) {
				if(val != '0')
				{
					return '<a href="index.php?controller=pjAdminComments&action=pjActionIndex&file_id='+obj.id+'">' + val + '</a>';
				}else{
					return val;
				}
			}
			function formatLast(val, obj) {
				if(val != null)
				{
					var by = obj.by_client != null ? obj.by_client : obj.by_user;
					return '<a href="index.php?controller=pjAdminComments&action=pjActionUpdate&id='+obj.last_id+'">' + val + '</a><br/>' + myLabel.by + ' ' + by;
				}else{
					return myLabel.na;
				}
			}
			
			var $grid = $("#grid").datagrid({
				buttons: [{type: "edit", url: "index.php?controller=pjAdminFiles&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminFiles&action=pjActionDeleteFile&id={:id}"}],
						  
				columns: [
				          	{text: myLabel.file_name, type: "text", sortable: true, editable: false, width: 230, renderer: formatFileName},
				          	{text: myLabel.uploaded, type: "text", sortable: true, editable: false, width: 130, renderer: formUploaded},
				          	{text: myLabel.comments, type: "text", sortable: true, editable: false, align: "center", width: 90, renderer: formatComments},
				          	{text: myLabel.last_comment, type: "text", sortable: true, editable: false, width: 130, renderer: formatLast}
				         ],
				dataUrl: "index.php?controller=pjAdminFiles&action=pjActionGetFile" + pjGrid.queryString,
				dataType: "json",
				fields: ['file_name', 'created', 'cnt_comments', 'last_comment'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminFiles&action=pjActionDeleteFileBulk", render: true, confirmation: myLabel.delete_confirmation},
					   {text: myLabel.download_selected, url: "index.php?controller=pjAdminFiles&action=pjActionDownloadFileBulk", ajax: false},
					   {text: myLabel.exported, url: "index.php?controller=pjAdminFiles&action=pjActionExportFile", ajax: false}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminFiles&action=pjActionSaveFile&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		
		if($dialogDelete.length > 0 && dialog)
		{
			$dialogDelete.dialog({
				autoOpen: false,
				resizable: false,
				draggable: false,
				modal: true,
				height: 160,
				width: 320,
				buttons: (function () {
					var buttons = {};
					buttons[fsApp.locale.button.delete] = function () {
						$.ajax({
							type: "GET",
							dataType: "json",
							url: "index.php?controller=pjAdminFiles&action=pjActionDeleteComment&id=" + $dialogDelete.data('id'),
							success: function (res) {
								if(res.code == 200)
								{
									$dialogDelete.dialog('close');
									window.location.href = 'index.php?controller=pjAdminFiles&action=pjActionComment&id=' + $dialogDelete.data('file_id');
								}
							}
						});
					};
					buttons[fsApp.locale.button.cancel] = function () {
						$dialogDelete.dialog("close");
					};
					
					return buttons;
				})()
			});
		}
		
		$(document).on("submit", ".frm-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val()
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminFiles&action=pjActionGetFile", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("click", ".pjFsDeleteComment", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$dialogDelete.data('id', $(this).attr('data-id')).data('file_id', $(this).attr('data-file_id')).dialog("open");
			return false;
		});
	});
})(jQuery_1_8_2);