(function (window, undefined){
	"use strict";
	pjQ.$.ajaxSetup({
		xhrFields: {
			withCredentials: true
		}
	});
	var document = window.document,
		validate = (pjQ.$.fn.validate !== undefined),
		routes = [
		          	{pattern: /^#!\/loadFiles$/, eventName: "loadFiles"},
		          	{pattern: /^#!\/loadLogin$/, eventName: "loadLogin"},
		          	{pattern: /^#!\/loadForgot$/, eventName: "loadForgot"},
		          	{pattern: /^#!\/loadFile\/id:(\d+)?$/, eventName: "loadFile"},
		          	{pattern: /^#!\/loadProfile$/, eventName: "loadProfile"},
		          	{pattern: /^#!\/loadAddFile$/, eventName: "loadAddFile"},
		         ];
	var tests = {
			dnd: 'draggable' in document.createElement('span'),
			formdata: !!window.FormData
		};
	function log() {
		if (window.console && window.console.log) {
			for (var x in arguments) {
				if (arguments.hasOwnProperty(x)) {
					window.console.log(arguments[x]);
				}
			}
		}
	}
	
	function assert() {
		if (window && window.console && window.console.assert) {
			window.console.assert.apply(window.console, arguments);
		}
	}
	
	function hashBang(value) {
		if (value !== undefined && value.match(/^#!\//) !== null) {
			if (window.location.hash == value) {
				return false;
			}
			window.location.hash = value;
			return true;
		}
		
		return false;
	}
	
	function onHashChange() {
		var i, iCnt, m;
		for (i = 0, iCnt = routes.length; i < iCnt; i++) {
			m = window.location.hash.match(routes[i].pattern);
			if (m !== null) {
				pjQ.$(window).trigger(routes[i].eventName, m.slice(1));
				break;
			}
		}
		if (m === null) {
			pjQ.$(window).trigger("loadFiles");
		}
	}
	pjQ.$(window).on("hashchange", function (e) {
    	onHashChange.call(null);
    });
	
	function FileSharing(opts) {
		if (!(this instanceof FileSharing)) {
			return new FileSharing(opts);
		}
				
		this.reset.call(this);
		this.init.call(this, opts);
		
		return this;
	}
	
	FileSharing.inObject = function (val, obj) {
		var key;
		for (key in obj) {
			if (obj.hasOwnProperty(key)) {
				if (obj[key] == val) {
					return true;
				}
			}
		}
		return false;
	};
	
	FileSharing.size = function(obj) {
		var key,
			size = 0;
		for (key in obj) {
			if (obj.hasOwnProperty(key)) {
				size += 1;
			}
		}
		return size;
	};
	
	FileSharing.prototype = {
		reset: function () {
			this.$container = null;			
			this.container = null;
			this.opts = {};
			this.id = null;
			this.column = null;
			this.direction = null;
			this.viewas = null;
			this.page = null;
			this.comment_page = null;
			this.file_arr = null;
			return this;
		},
		
		disableButtons: function () {
			this.$container.find(".btn").each(function (i, el) {
				pjQ.$(el).attr("disabled", "disabled");
			});
		},
		enableButtons: function () {
			this.$container.find(".btn").removeAttr("disabled");
		},
		
		init: function (opts) {
			var self = this;
			this.opts = opts;
			this.container = document.getElementById("pjFsContainer_" + self.opts.index);
						
			self.$container = pjQ.$(self.container);
			
			self.$container.on("click.fs", '.pjFsBtnMenu', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				self.disableButtons.call(self);
				var load = pjQ.$(this).attr('data-load');
				if (!hashBang("#!/" + load)) 
				{
					pjQ.$(window).trigger("#!/" + load);
				}
				return false;
			}).on("click.fs", '.pjFsBtnLinkForgot', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				self.disableButtons.call(self);
				if (!hashBang("#!/loadForgot")) 
				{
					self.loadForgot.call(self);
				}
				return false;
			}).on("click.fs", '.pjFsBtnLinkLogin', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				self.disableButtons.call(self);
				if (!hashBang("#!/loadLogin")) 
				{
					self.loadLogin.call(self);
				}
				return false;
			}).on("click.fs", '.pjFsPageNode', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				self.page = pjQ.$(this).attr('data-page');
				self.disableButtons.call(self);
				if (!hashBang("#!/loadFiles")) 
				{
					self.loadFiles.call(self);
				}
				return false;
			}).on("click.fs", '.pjFsViewAs', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				self.viewas = pjQ.$(this).attr('data-viewas');
				self.disableButtons.call(self);
				if (!hashBang("#!/loadFiles")) 
				{
					self.loadFiles.call(self);
				}
				return false;
			}).on("click.fs", '.pjFsSortBy', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				self.column = pjQ.$(this).attr('data-column'),
				self.direction = pjQ.$(this).attr('data-direction');
				self.disableButtons.call(self);
				if (!hashBang("#!/loadFiles")) 
				{
					self.loadFiles.call(self);
				}
				return false;
			}).on("click.fs", '.pjFsRemoveFile', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var $this = pjQ.$(this),
					id = pjQ.$(this).attr('data-id');
				
				pjQ.$('#pjFsDeleteButton_' + self.opts.index).attr('data-id', id);
				pjQ.$('#pjFsDeleteFileModal').modal('show');
				return false;
			}).on("click.fs", '.pjFsFavorite', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var $this = pjQ.$(this),
					action = 'pjActionSetFavorite',
					params = {};
				if($this.hasClass('pjFsThumbStarChecked'))
				{
					action = 'pjActionUnSetFavorite';
				}
				if(self.opts.session_id != '')
				{
					params.session_id = self.opts.session_id;
				}
				pjQ.$.get(self.opts.folder + "index.php?controller=pjFrontJs&action="+action+"&file_id=" + $this.attr('data-id'), params).done(function(data) {
					if(data.code == '200')
					{
						if($this.hasClass('pjFsThumbStarChecked'))
						{
							$this.removeClass('pjFsThumbStarChecked');
						}else{
							$this.addClass('pjFsThumbStarChecked');
						}
					}
				});
				return false;
			}).on("click.fs", '.pjFsFileDetails', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var $this = pjQ.$(this),
					id = pjQ.$(this).attr('data-id');
				if (!hashBang("#!/loadFile/id:" + id)) 
				{
					pjQ.$(window).trigger("#!/loadFile/id:" + id);
				}
				return false;
			}).on("click.fs", '.pjFsCommentPageNode', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				self.comment_page = pjQ.$(this).attr('data-page');
				self.disableButtons.call(self);
				self.loadComments.call(self);
				return false;
			}).on("click.fs", '.pjFsBtnLogout', function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var params = {};
				if(self.opts.session_id != '')
				{
					params.session_id = self.opts.session_id;
				}
				pjQ.$.get(self.opts.folder + "index.php?controller=pjFrontJs&action=pjActionLogout", params).done(function(data) {
					if (!hashBang("#!/loadLogin")) 
					{
						self.loadLogin.call(self);
					}
				});
				return false;
			});
			
			pjQ.$(document).on("click.fs", '#pjFsDeleteButton_' + self.opts.index, function(e){
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var $this = pjQ.$(this),
					id = pjQ.$(this).attr('data-id'),
					params = {};
				if(self.opts.session_id != '')
				{
					params.session_id = self.opts.session_id;
				}
				pjQ.$.get(self.opts.folder + "index.php?controller=pjFrontJs&action=pjActionDeleteFile&id=" + id, params).done(function (data) {
					if(data.code == '200')
					{
						if (!hashBang("#!/loadFiles")) 
						{
							self.loadFiles.call(self);
						}
						pjQ.$('#pjFsDeleteFileModal').modal('hide');
					}else{
						pjQ.$('#pjFsDeleteFileModal').modal('hide');
						pjQ.$('#pjFsPermissionModal').modal('show');
					}
				});
				return false;
			});
			
			pjQ.$(window).on("loadFiles", this.$container, function (e) {
				self.loadFiles.call(self);
			}).on("loadLogin", this.$container, function (e) {
				self.loadLogin.call(self);
			}).on("loadForgot", this.$container, function (e) {
				self.loadForgot.call(self);
			}).on("loadFile", this.$container, function (e) {
				if(arguments.length == 2)
				{
					self.id = arguments[1];
				}
				self.loadFile.call(self);
			}).on("loadProfile", this.$container, function (e) {
				self.loadProfile.call(self);
			}).on("loadAddFile", this.$container, function (e) {
				self.loadAddFile.call(self);
			});
			
			if (window.location.hash.length === 0) {
				this.loadFiles.call(this);
			} else {
				onHashChange.call(null);
			}
		},
		
		loadFiles: function () {
			var self = this,
				index = this.opts.index,
				params = {};
			params.index = this.opts.index;
			if(self.opts.session_id != '')
			{
				params.session_id = self.opts.session_id;
			}
			if(self.column != null)
			{
				params.column = self.column;
			}
			if(self.direction != null)
			{
				params.direction = self.direction;
			}
			if(self.page != null)
			{
				params.pjPage = self.page;
			}else{
				params.pjPage = 1;
			}
			if(self.viewas != null)
			{
				params.viewas = self.viewas;
			}
			pjQ.$.get([this.opts.folder, "index.php?controller=pjFrontJs&action=pjActionIndex"].join(""), params).done(function (data) {
				if (data.code != undefined && data.status == 'ERR') {
					if (!hashBang("#!/loadLogin")) 
					{
						self.loadLogin.call(self);
					}
				}else{
					self.$container.html(data);
					pjQ.$('html, body').animate({
				        scrollTop: self.$container.offset().top
				    }, 500);
					pjQ.$('.modal-dialog').css("z-index", "9999");
				}
			}).fail(function () {
				
			});
		},
		loadLogin: function () {
			var self = this,
				index = this.opts.index,
				params = {};
			params.index = this.opts.index;
			if(self.opts.session_id != '')
			{
				params.session_id = self.opts.session_id;
			}
			pjQ.$.get([this.opts.folder, "index.php?controller=pjFrontJs&action=pjActionLogin"].join(""), params).done(function (data) {
				self.$container.html(data);
				self.bindLogin.call(self);
				pjQ.$('html, body').animate({
			        scrollTop: self.$container.offset().top
			    }, 500);
			}).fail(function () {
				
			});
		},
		bindLogin: function(){
			var self = this;
			var $frmLogin = pjQ.$('#pjFsLoginForm_' + self.opts.index);
			
			if($frmLogin.length > 0 && validate)
			{
				$frmLogin.validate({
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.next().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().removeClass('has-error').addClass('has-success');
		            },
		            submitHandler: function (form) {
						self.disableButtons.call(self);
						var $form = pjQ.$(form);
						var ajax_url = [self.opts.folder, "index.php?controller=pjFrontJs&action=pjActionLogin"].join("");
						if(self.opts.session_id != '')
						{
							ajax_url = [self.opts.folder, "index.php?controller=pjFrontJs&action=pjActionLogin", "&session_id=", self.opts.session_id].join("");
						}
						pjQ.$.post(ajax_url, $form.serialize()).done(function (data) {
							if(data.code == '200')
							{
								if (!hashBang("#!/loadFiles")) 
								{
									self.loadFiles.call(self);
								}
							}else{
								var $loginMessage = pjQ.$('#pjFsLoginMessage_'+ self.opts.index);
								$loginMessage.html(data.text);
								$loginMessage.show();
								self.enableButtons.call(self);
							}
						}).fail(function () {
							self.enableButtons.call(self);
						});
						return false;
					}
				});
			}
		},
		loadForgot: function () {
			var self = this,
				index = this.opts.index,
				params = {};
			params.index = this.opts.index;
			if(self.opts.session_id != '')
			{
				params.session_id = self.opts.session_id;
			}
			pjQ.$.get([this.opts.folder, "index.php?controller=pjFrontJs&action=pjActionForgot"].join(""), params).done(function (data) {
				self.$container.html(data);
				self.bindForgot.call(self);
				pjQ.$('html, body').animate({
			        scrollTop: self.$container.offset().top
			    }, 500);
			}).fail(function () {
				
			});
		},
		bindForgot: function(){
			var self = this,
				$frmForgot = pjQ.$('#pjFsForgotForm_' + self.opts.index);
			if($frmForgot.length > 0 && validate)
			{
				$frmForgot.validate({
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.next().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().removeClass('has-error').addClass('has-success');
		            },
		            submitHandler: function (form) {
						self.disableButtons.call(self);
						var $form = pjQ.$(form);
						var ajax_url = [self.opts.folder, "index.php?controller=pjFrontJs&action=pjActionForgot"].join("");
						if(self.opts.session_id != '')
						{
							ajax_url = [self.opts.folder, "index.php?controller=pjFrontJs&action=pjActionForgot", "&session_id=", self.opts.session_id].join("");
						}
						pjQ.$.post(ajax_url, $form.serialize()).done(function (data) {
							var $forgotMessage = pjQ.$('#pjFsForgotMessage_'+ self.opts.index);
							if(data.code == '200')
							{
								$forgotMessage.removeClass('alert-danger').addClass('alert-success').html(data.text);
							}else{
								$forgotMessage.removeClass('alert-success').addClass('alert-danger').html(data.text);
							}
							$forgotMessage.show();
							self.enableButtons.call(self);
						}).fail(function () {
							self.enableButtons.call(self);
						});
						return false;
					}
				});
			}
		},
		loadFile: function () {
			var self = this,
				index = this.opts.index,
				params = {};
			params.index = this.opts.index;
			if(self.opts.session_id != '')
			{
				params.session_id = self.opts.session_id;
			}
			if(self.id != null)
			{
				params.id = self.id;
			}
			pjQ.$.get([this.opts.folder, "index.php?controller=pjFrontJs&action=pjActionView"].join(""), params).done(function (data) {
				if (data.code != undefined && data.status == 'ERR') {
					if (!hashBang("#!/loadLogin")) 
					{
						self.loadLogin.call(self);
					}
				}else{
					self.$container.html(data);
					self.bindComments.call(self);
					pjQ.$('html, body').animate({
				        scrollTop: self.$container.offset().top
				    }, 500);
				}
			}).fail(function () {
				
			});
		},
		bindComments: function(){
			var self = this,
				$pjFsCommentForm = pjQ.$('#pjFsCommentForm_' + self.opts.index),
				$frmCommentList = pjQ.$('#pjFsCommentListForm_' + self.opts.index),
				params = {};
			
			if(self.opts.session_id != '')
			{
				params.session_id = self.opts.session_id;
			}
			if($pjFsCommentForm.length > 0 && validate)
			{
				$pjFsCommentForm.validate({
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.next().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().removeClass('has-error').addClass('has-success');
		            },
		            submitHandler: function (form) {
						self.disableButtons.call(self);
						var $form = pjQ.$(form);
						var ajax_url = [self.opts.folder, "index.php?controller=pjFrontJs&action=pjActionSaveComment"].join("");
						if(self.opts.session_id != '')
						{
							ajax_url = [self.opts.folder, "index.php?controller=pjFrontJs&action=pjActionSaveComment", "&session_id=", self.opts.session_id].join("");
						}
						pjQ.$.post(ajax_url, $form.serialize()).done(function (data) {
							var $message = pjQ.$('#pjFsCommentMessage_'+ self.opts.index);
							if(data.code == '200')
							{
								$message.removeClass('alert-danger').addClass('alert-success').html(data.text);
								$pjFsCommentForm.find('textarea[name="comment"]').val("");
							}else{
								$message.removeClass('alert-success').addClass('alert-danger').html(data.text);
							}
							$message.show();
							self.loadComments.call(self);
							self.enableButtons.call(self);
						}).fail(function () {
							self.enableButtons.call(self);
						});
						return false;
					}
				});
			}
		},
		loadComments: function () {
			var self = this,
				index = this.opts.index,
				params = {};
			params.index = this.opts.index;
			if(self.opts.session_id != '')
			{
				params.session_id = self.opts.session_id;
			}
			if(self.id != null)
			{
				params.id = self.id;
			}
			if(self.comment_page != null)
			{
				params.pjPage = self.comment_page;
			}else{
				params.pjPage = 1;
			}
			pjQ.$.get([this.opts.folder, "index.php?controller=pjFrontJs&action=pjActionGetComments"].join(""), params).done(function (data) {
				pjQ.$('#pjFsCommentList_' + self.opts.index).html(data);
			}).fail(function () {
				
			});
		},
		loadProfile: function () {
			var self = this,
				index = this.opts.index,
				params = {};
			params.index = this.opts.index;
			if(self.opts.session_id != '')
			{
				params.session_id = self.opts.session_id;
			}
			pjQ.$.get([this.opts.folder, "index.php?controller=pjFrontJs&action=pjActionProfile"].join(""), params).done(function (data) {
				if (data.code != undefined && data.status == 'ERR') {
					if (!hashBang("#!/loadLogin")) 
					{
						self.loadLogin.call(self);
					}
				}else{
					self.$container.html(data);
					self.bindProfile.call(self);
					pjQ.$('html, body').animate({
				        scrollTop: self.$container.offset().top
				    }, 500);
				}
			}).fail(function () {
				
			});
		},
		bindProfile: function(){
			var self = this,
				$frmProfile = pjQ.$('#pjFsProfileForm_' + self.opts.index);
			if($frmProfile.length > 0 && validate)
			{
				$frmProfile.validate({
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.next().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().removeClass('has-error').addClass('has-success');
		            },
		            submitHandler: function (form) {
						self.disableButtons.call(self);
						var $form = pjQ.$(form);
						var ajax_url = [self.opts.folder, "index.php?controller=pjFrontJs&action=pjActionProfile"].join("");
						if(self.opts.session_id != '')
						{
							ajax_url = [self.opts.folder, "index.php?controller=pjFrontJs&action=pjActionProfile", "&session_id=", self.opts.session_id].join("");
						}
						pjQ.$.post(ajax_url, $form.serialize()).done(function (data) {
							var $message = pjQ.$('#pjFsProfileMessage_'+ self.opts.index);
							if(data.code == '200')
							{
								$message.removeClass('alert-danger').addClass('alert-success').html(data.text);
							}else{
								$message.removeClass('alert-success').addClass('alert-danger').html(data.text);
							}
							$message.show();
							self.enableButtons.call(self);
						}).fail(function () {
							self.enableButtons.call(self);
						});
						return false;
					}
				});
			}
		},
		loadAddFile: function () {
			var self = this,
				index = this.opts.index,
				params = {};
			params.index = this.opts.index;
			if(self.opts.session_id != '')
			{
				params.session_id = self.opts.session_id;
			}
			pjQ.$.get([this.opts.folder, "index.php?controller=pjFrontJs&action=pjActionAddFile"].join(""), params).done(function (data) {
				if (data.code != undefined && data.status == 'ERR') {
					if (!hashBang("#!/loadLogin")) 
					{
						self.loadLogin.call(self);
					}
				}else{
					self.$container.html(data);
					self.bindAddFile.call(self);
					pjQ.$('html, body').animate({
				        scrollTop: self.$container.offset().top
				    }, 500);
				}
			}).fail(function () {
				
			});
		},
		bindAddFile: function(){
			var self = this,
				$frmAddFile = pjQ.$('#pjFsAddFileForm_' + self.opts.index),
				$btnSubmit = pjQ.$('.pjFsBtnSubmitForm');
			
			if (pjQ.$('.pjFsAddFile').length) {
				var holderSelector = '.pjFsAddFile';
				var hasSelectedClass = 'pjFsAddFileAdded';
				var inputSelector = '.pjFsFileUploadField';
				var namesSelector = '.pjFsUploadedFiles';
				var messageSelector = '.pjFsExtensionMessage';
				var multipleNamesDivider = '; ';

				pjQ.$(inputSelector).on('change', function() {
					var input = this,
						files = input.files,
						allowed_ext = pjQ.$(input).attr('data-extension'),
						valid = false;
					
					pjQ.$('#pjFsAddFileMessage_'+ self.opts.index).hide();
					$btnSubmit.find('i').remove();
					
					pjQ.$.map(files, function(file) {
						var file_name = file.name,
							file_extension = file_name.substr( (file_name.lastIndexOf('.') + 1) );
						if(allowed_ext != '')
						{
							var allowed_arr = allowed_ext.split("|");
							if(pjQ.$.inArray(file_extension, allowed_arr) > -1)
							{
								valid = true;
							}
						}
					});
					pjQ.$(input).closest(holderSelector).toggleClass(hasSelectedClass, input.value !== '').find(namesSelector)
						.text(
							pjQ.$.map(files, function(file) {
								var file_name = file.name;
								return file.name;
							}).join(multipleNamesDivider)
						);
					if(valid == false)
					{
						pjQ.$(messageSelector).show();
						$btnSubmit.attr('disabled','disabled');
					}else{
						self.file_arr = files;
					}
				});

				pjQ.$('.pjFsBtnRemoveFile').on('click', function(e) {
					e.preventDefault();
					if (pjQ.$(this).attr('disabled') === undefined) 
					{
						pjQ.$(holderSelector).removeClass(hasSelectedClass);
						pjQ.$(inputSelector).val('');
						pjQ.$(namesSelector).text('');
						pjQ.$(messageSelector).hide();
						$btnSubmit.removeAttr('disabled');
					}
				});

				self.$container.on('dragenter dragover drop', function(e) {
					if ((e.type === 'dragenter') && (pjQ.$(e.target).parents('.pjFsDroppableArea').length)) {
						pjQ.$(holderSelector).addClass('pjFsReadyForDrop');
					} else if ((e.type === 'dragenter') && (!pjQ.$(e.target).parents('.pjFsDroppableArea').length)) {
						pjQ.$(holderSelector).removeClass('pjFsReadyForDrop');
					} else if ((e.type === 'dragover') && (pjQ.$(e.target).parent().hasClass('pjFsBtnUpload'))) {
						pjQ.$('.pjFsBtnUpload').addClass('pjFsBtnReadyForDrop');
					} else if ((e.type === 'dragover') && (!pjQ.$(e.target).parent().hasClass('pjFsBtnUpload'))) {
						pjQ.$('.pjFsBtnUpload').removeClass('pjFsBtnReadyForDrop');
					} else if ((e.type === 'drop') && (pjQ.$(e.target).parent().hasClass('pjFsBtnUpload'))) {
						pjQ.$(holderSelector).removeClass('pjFsReadyForDrop');
						pjQ.$('.pjFsBtnUpload').removeClass('pjFsBtnReadyForDrop');
					};
				});
				
				$btnSubmit.on('click', function(e) {
					$btnSubmit.prepend( '<i class="fa fa-refresh fa-spin"></i>' ).attr('disabled','disabled');
					pjQ.$('.pjFsBtnRemoveFile').attr('disabled','disabled');
					self.readFiles.call(self);
				});
			};
		},
		readFiles: function () {
			var self = this,
				index = this.opts.index,
				params = {};
			params.index = this.opts.index;
			
			var formData = tests.formdata ? new FormData() : new FData();
			var files = self.file_arr;
			formData.append('add_file', 1);
			for (var i = 0; i < files.length; i++) {
				formData.append('files[]', files[i]);
			}
			
			var ajax_url = [self.opts.folder, "index.php?controller=pjFrontJs&action=pjActionAddFile"].join("");
			if(self.opts.session_id != '')
			{
				ajax_url = [self.opts.folder, "index.php?controller=pjFrontJs&action=pjActionAddFile", "&session_id=", self.opts.session_id].join("");
			}
			pjQ.$.ajax({
			    url: ajax_url,
			    type: 'POST',
			    data: formData,
			    dataType: 'json',
			    cache: false,
			    contentType: false,
			    processData: false,
			    complete: function() {
			    	
			    },
			    xhr: function() {
	                var myXhr = pjQ.$.ajaxSettings.xhr();
	                if(myXhr.upload){
	                    
	                }
	                return myXhr;
			    },
			    success: function(data) {
			    	self.file_arr = null;
			    	var $message = pjQ.$('#pjFsAddFileMessage_'+ self.opts.index);
					if(data.code == '200')
					{
						$message.removeClass('alert-danger').addClass('alert-success').html(data.text);
					}else{
						$message.removeClass('alert-success').addClass('alert-danger').html(data.text);
					}
					$message.show();
					pjQ.$('.pjFsBtnRemoveFile').removeAttr('disabled','disabled').trigger('click');
			    },
			    error: function() {
			      
			    }
			});
		},
	};
	
	window.FileSharing = FileSharing;	
})(window);